/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tape;

import com.squareup.tape.ObjectQueue;
import java.util.LinkedList;
import java.util.Queue;

public class InMemoryObjectQueue<T>
implements ObjectQueue<T> {
    private final Queue<T> tasks = new LinkedList<T>();
    private ObjectQueue.Listener<T> listener;

    @Override
    public void add(T entry) {
        this.tasks.add(entry);
        if (this.listener != null) {
            this.listener.onAdd(this, entry);
        }
    }

    @Override
    public T peek() {
        return this.tasks.peek();
    }

    @Override
    public int size() {
        return this.tasks.size();
    }

    @Override
    public void remove() {
        this.tasks.remove();
        if (this.listener != null) {
            this.listener.onRemove(this);
        }
    }

    @Override
    public void setListener(ObjectQueue.Listener<T> listener) {
        if (listener != null) {
            for (Object task : this.tasks) {
                listener.onAdd(this, task);
            }
        }
        this.listener = listener;
    }
}

