/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.wire;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import retrofit2.Converter;
import retrofit2.converter.wire.WireStreamingRequestBody;

final class WireRequestBodyConverter<T extends Message<T, ?>>
implements Converter<T, RequestBody> {
    static final MediaType MEDIA_TYPE = MediaType.get((String)"application/x-protobuf");
    private final ProtoAdapter<T> adapter;
    private final boolean streaming;

    WireRequestBodyConverter(ProtoAdapter<T> adapter, boolean streaming) {
        this.adapter = adapter;
        this.streaming = streaming;
    }

    public RequestBody convert(T value) throws IOException {
        if (this.streaming) {
            return new WireStreamingRequestBody<T>(this.adapter, value);
        }
        Buffer buffer = new Buffer();
        this.adapter.encode((BufferedSink)buffer, value);
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.snapshot());
    }
}

