/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.MessageType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExtendDeclaration {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<MessageType.Field> fields;

    public ExtendDeclaration(String name, String fqname, String documentation, List<MessageType.Field> fields) {
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.fields = Collections.unmodifiableList(new ArrayList<MessageType.Field>(fields));
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        return this.fqname;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<MessageType.Field> getFields() {
        return this.fields;
    }

    public boolean equals(Object other) {
        if (other instanceof ExtendDeclaration) {
            ExtendDeclaration that = (ExtendDeclaration)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.fields.equals(that.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("extend %s %s %s", this.name, this.fqname, this.documentation));
        for (MessageType.Field field : this.fields) {
            result.append("\n  ").append(field);
        }
        return result.toString();
    }
}

