/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.net.ProtocolException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.tls.internal.der.DerAdapter;
import okhttp3.tls.internal.der.DerHeader;
import okhttp3.tls.internal.der.DerReader;
import okhttp3.tls.internal.der.DerWriter;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00018BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010(J\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\b\u0010*\u001a\u00020\u0006H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016J\t\u0010,\u001a\u00020\u0004H\u00c2\u0003J\t\u0010-\u001a\u00020\u0006H\u00c6\u0003J\t\u0010.\u001a\u00020\bH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u00c2\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J\u0010\u00101\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\t\u00102\u001a\u00020\fH\u00c2\u0003Jb\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u00002\b\b\u0002\u0010\u000e\u001a\u00020\fH\u00c6\u0001\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u00020\f2\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0015R\u0015\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lokhttp3/tls/internal/der/BasicDerAdapter;", "T", "Lokhttp3/tls/internal/der/DerAdapter;", "name", "", "tagClass", "", "tag", "", "codec", "Lokhttp3/tls/internal/der/BasicDerAdapter$Codec;", "isOptional", "", "defaultValue", "typeHint", "<init>", "(Ljava/lang/String;IJLokhttp3/tls/internal/der/BasicDerAdapter$Codec;ZLjava/lang/Object;Z)V", "getTagClass", "()I", "getTag", "()J", "()Z", "getDefaultValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "matches", "header", "Lokhttp3/tls/internal/der/DerHeader;", "fromDer", "reader", "Lokhttp3/tls/internal/der/DerReader;", "(Lokhttp3/tls/internal/der/DerReader;)Ljava/lang/Object;", "toDer", "", "writer", "Lokhttp3/tls/internal/der/DerWriter;", "value", "(Lokhttp3/tls/internal/der/DerWriter;Ljava/lang/Object;)V", "withTag", "optional", "(Ljava/lang/Object;)Lokhttp3/tls/internal/der/BasicDerAdapter;", "asTypeHint", "hashCode", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;IJLokhttp3/tls/internal/der/BasicDerAdapter$Codec;ZLjava/lang/Object;Z)Lokhttp3/tls/internal/der/BasicDerAdapter;", "equals", "other", "", "Codec", "okhttp-tls"})
@SourceDebugExtension(value={"SMAP\nBasicDerAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicDerAdapter.kt\nokhttp3/tls/internal/der/BasicDerAdapter\n+ 2 DerReader.kt\nokhttp3/tls/internal/der/DerReader\n*L\n1#1,145:1\n169#2,30:146\n*S KotlinDebug\n*F\n+ 1 BasicDerAdapter.kt\nokhttp3/tls/internal/der/BasicDerAdapter\n*L\n56#1:146,30\n*E\n"})
public final class BasicDerAdapter<T>
implements DerAdapter<T> {
    @NotNull
    private final String name;
    private final int tagClass;
    private final long tag;
    @NotNull
    private final Codec<T> codec;
    private final boolean isOptional;
    @Nullable
    private final T defaultValue;
    private final boolean typeHint;

    public BasicDerAdapter(@NotNull String name, int tagClass, long tag, @NotNull Codec<T> codec2, boolean isOptional, @Nullable T defaultValue, boolean typeHint) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(codec2, (String)"codec");
        this.name = name;
        this.tagClass = tagClass;
        this.tag = tag;
        this.codec = codec2;
        this.isOptional = isOptional;
        this.defaultValue = defaultValue;
        this.typeHint = typeHint;
        if (!(this.tagClass >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.tag >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ BasicDerAdapter(String string, int n, long l, Codec codec2, boolean bl, Object object, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            object = null;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = false;
        }
        this(string, n, l, codec2, bl, object, bl2);
    }

    public final int getTagClass() {
        return this.tagClass;
    }

    public final long getTag() {
        return this.tag;
    }

    public final boolean isOptional() {
        return this.isOptional;
    }

    @Nullable
    public final T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean matches(@NotNull DerHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return header.getTagClass() == this.tagClass && header.getTag() == this.tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public T fromDer(@NotNull DerReader reader) {
        T t;
        long newLimit$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        DerHeader peekedHeader = reader.peekHeader();
        if (peekedHeader == null || peekedHeader.getTagClass() != this.tagClass || peekedHeader.getTag() != this.tag) {
            if (this.isOptional) {
                return this.defaultValue;
            }
            throw new ProtocolException("expected " + this + " but was " + peekedHeader + " at " + reader);
        }
        DerReader derReader = reader;
        String name$iv = this.name;
        boolean $i$f$read$okhttp_tls = false;
        if (!this_$iv.hasNext()) {
            throw new ProtocolException("expected a value");
        }
        DerHeader derHeader = DerReader.access$getPeekedHeader$p((DerReader)this_$iv);
        Intrinsics.checkNotNull((Object)derHeader);
        DerHeader header$iv = derHeader;
        DerReader.access$setPeekedHeader$p((DerReader)this_$iv, null);
        long pushedLimit$iv = DerReader.access$getLimit$p((DerReader)this_$iv);
        boolean pushedConstructed$iv = DerReader.access$getConstructed$p((DerReader)this_$iv);
        long l = newLimit$iv = header$iv.getLength() != -1L ? DerReader.access$getByteCount((DerReader)this_$iv) + header$iv.getLength() : -1L;
        if (pushedLimit$iv != -1L && newLimit$iv > pushedLimit$iv) {
            throw new ProtocolException("enclosed object too large");
        }
        DerReader.access$setLimit$p((DerReader)this_$iv, newLimit$iv);
        DerReader.access$setConstructed$p((DerReader)this_$iv, header$iv.getConstructed());
        if (name$iv != null) {
            ((Collection)DerReader.access$getPath$p((DerReader)this_$iv)).add(name$iv);
        }
        try {
            DerHeader it = header$iv;
            boolean bl = false;
            T result$iv = this.codec.decode(reader);
            if (newLimit$iv != -1L && DerReader.access$getByteCount((DerReader)this_$iv) > newLimit$iv) {
                throw new ProtocolException("unexpected byte count at " + this_$iv);
            }
            t = result$iv;
        }
        finally {
            DerReader.access$setPeekedHeader$p((DerReader)this_$iv, null);
            DerReader.access$setLimit$p((DerReader)this_$iv, pushedLimit$iv);
            DerReader.access$setConstructed$p((DerReader)this_$iv, pushedConstructed$iv);
            if (name$iv != null) {
                DerReader.access$getPath$p((DerReader)this_$iv).remove(DerReader.access$getPath$p((DerReader)this_$iv).size() - 1);
            }
        }
        T result = t;
        if (this.typeHint) {
            reader.setTypeHint(result);
        }
        return result;
    }

    @Override
    public void toDer(@NotNull DerWriter writer, T value) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (this.typeHint) {
            writer.setTypeHint(value);
        }
        if (this.isOptional && Intrinsics.areEqual(value, this.defaultValue)) {
            return;
        }
        writer.write(this.name, this.tagClass, this.tag, (Function1<? super BufferedSink, Unit>)((Function1)arg_0 -> BasicDerAdapter.toDer$lambda$0(this, writer, value, arg_0)));
    }

    @NotNull
    public final BasicDerAdapter<T> withTag(int tagClass, long tag) {
        return BasicDerAdapter.copy$default(this, null, tagClass, tag, null, false, null, false, 121, null);
    }

    public static /* synthetic */ BasicDerAdapter withTag$default(BasicDerAdapter basicDerAdapter, int n, long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        return basicDerAdapter.withTag(n, l);
    }

    @NotNull
    public final BasicDerAdapter<T> optional(@Nullable T defaultValue) {
        return BasicDerAdapter.copy$default(this, null, 0, 0L, null, true, defaultValue, false, 79, null);
    }

    public static /* synthetic */ BasicDerAdapter optional$default(BasicDerAdapter basicDerAdapter, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        return basicDerAdapter.optional(object);
    }

    @NotNull
    public final BasicDerAdapter<T> asTypeHint() {
        return BasicDerAdapter.copy$default(this, null, 0, 0L, null, false, null, true, 63, null);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.tagClass;
        result = 31 * result + (int)this.tag;
        result = 31 * result + this.codec.hashCode();
        result = 31 * result + (this.isOptional ? 1 : 0);
        T t = this.defaultValue;
        result = 31 * result + (t != null ? t.hashCode() : 0);
        result = 31 * result + (this.typeHint ? 1 : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return this.name + " [" + this.tagClass + '/' + this.tag + ']';
    }

    private final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.tagClass;
    }

    public final long component3() {
        return this.tag;
    }

    private final Codec<T> component4() {
        return this.codec;
    }

    public final boolean component5() {
        return this.isOptional;
    }

    @Nullable
    public final T component6() {
        return this.defaultValue;
    }

    private final boolean component7() {
        return this.typeHint;
    }

    @NotNull
    public final BasicDerAdapter<T> copy(@NotNull String name, int tagClass, long tag, @NotNull Codec<T> codec2, boolean isOptional, @Nullable T defaultValue, boolean typeHint) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(codec2, (String)"codec");
        return new BasicDerAdapter<T>(name, tagClass, tag, codec2, isOptional, defaultValue, typeHint);
    }

    public static /* synthetic */ BasicDerAdapter copy$default(BasicDerAdapter basicDerAdapter, String string, int n, long l, Codec codec2, boolean bl, Object object, boolean bl2, int n2, Object object2) {
        if ((n2 & 1) != 0) {
            string = basicDerAdapter.name;
        }
        if ((n2 & 2) != 0) {
            n = basicDerAdapter.tagClass;
        }
        if ((n2 & 4) != 0) {
            l = basicDerAdapter.tag;
        }
        if ((n2 & 8) != 0) {
            codec2 = basicDerAdapter.codec;
        }
        if ((n2 & 0x10) != 0) {
            bl = basicDerAdapter.isOptional;
        }
        if ((n2 & 0x20) != 0) {
            object = basicDerAdapter.defaultValue;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = basicDerAdapter.typeHint;
        }
        return basicDerAdapter.copy(string, n, l, codec2, bl, object, bl2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicDerAdapter)) {
            return false;
        }
        BasicDerAdapter basicDerAdapter = (BasicDerAdapter)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)basicDerAdapter.name)) {
            return false;
        }
        if (this.tagClass != basicDerAdapter.tagClass) {
            return false;
        }
        if (this.tag != basicDerAdapter.tag) {
            return false;
        }
        if (!Intrinsics.areEqual(this.codec, basicDerAdapter.codec)) {
            return false;
        }
        if (this.isOptional != basicDerAdapter.isOptional) {
            return false;
        }
        if (!Intrinsics.areEqual(this.defaultValue, basicDerAdapter.defaultValue)) {
            return false;
        }
        return this.typeHint == basicDerAdapter.typeHint;
    }

    private static final Unit toDer$lambda$0(BasicDerAdapter this$0, DerWriter $writer, Object $value, BufferedSink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.codec.encode($writer, $value);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lokhttp3/tls/internal/der/BasicDerAdapter$Codec;", "T", "", "decode", "reader", "Lokhttp3/tls/internal/der/DerReader;", "(Lokhttp3/tls/internal/der/DerReader;)Ljava/lang/Object;", "encode", "", "writer", "Lokhttp3/tls/internal/der/DerWriter;", "value", "(Lokhttp3/tls/internal/der/DerWriter;Ljava/lang/Object;)V", "okhttp-tls"})
    public static interface Codec<T> {
        public T decode(@NotNull DerReader var1);

        public void encode(@NotNull DerWriter var1, T var2);
    }
}

