/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.curl.logging.MessageFormatter;
import okhttp3.curl.logging.OneLineLogFormat;
import okhttp3.internal.http2.Http2;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lokhttp3/curl/logging/LoggingUtil;", "", "<init>", "()V", "Companion", "okcurl"})
public final class LoggingUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Logger> activeLoggers = new ArrayList();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/curl/logging/LoggingUtil$Companion;", "", "<init>", "()V", "activeLoggers", "", "Ljava/util/logging/Logger;", "configureLogging", "", "debug", "", "showHttp2Frames", "sslDebug", "getLogger", "name", "", "okcurl"})
    public static final class Companion {
        private Companion() {
        }

        public final void configureLogging(boolean debug, boolean showHttp2Frames, boolean sslDebug) {
            if (debug || showHttp2Frames || sslDebug) {
                if (sslDebug) {
                    System.setProperty("javax.net.debug", "");
                }
                LogManager.getLogManager().reset();
                ConsoleHandler handler2 = new ConsoleHandler(sslDebug){
                    final /* synthetic */ boolean $sslDebug;
                    {
                        this.$sslDebug = $sslDebug;
                    }

                    public void publish(LogRecord record) {
                        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                        super.publish(record);
                        Object[] parameters = record.getParameters();
                        if (this.$sslDebug && Intrinsics.areEqual((Object)record.getLoggerName(), (Object)"javax.net.ssl") && parameters != null) {
                            System.err.println(parameters[0]);
                        }
                    }
                };
                if (debug) {
                    handler2.setLevel(Level.ALL);
                    handler2.setFormatter(new OneLineLogFormat());
                    Logger activeLogger = this.getLogger("");
                    activeLogger.addHandler(handler2);
                    activeLogger.setLevel(Level.ALL);
                    this.getLogger("jdk.event.security").setLevel(Level.INFO);
                    this.getLogger("org.conscrypt").setLevel(Level.INFO);
                } else {
                    Logger activeLogger;
                    if (showHttp2Frames) {
                        String string = Http2.class.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        activeLogger = this.getLogger(string);
                        activeLogger.setLevel(Level.FINE);
                        handler2.setLevel(Level.FINE);
                        handler2.setFormatter(MessageFormatter.INSTANCE);
                        activeLogger.addHandler(handler2);
                    }
                    if (sslDebug) {
                        activeLogger = this.getLogger("javax.net.ssl");
                        activeLogger.setLevel(Level.FINEST);
                        handler2.setLevel(Level.FINEST);
                        handler2.setFormatter(MessageFormatter.INSTANCE);
                        activeLogger.addHandler(handler2);
                    }
                }
            }
        }

        @NotNull
        public final Logger getLogger(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Logger logger2 = Logger.getLogger(name);
            List list = activeLoggers;
            Intrinsics.checkNotNull((Object)logger2);
            list.add(logger2);
            return logger2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

