/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\t\u0010\u000f\u001a\u00020\u0007H\u0096\u0001J\t\u0010\u0010\u001a\u00020\u0007H\u0096\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmockwebserver3/internal/TriggerSink;", "Lokio/Sink;", "delegate", "triggerByteCount", "", "trigger", "Lkotlin/Function0;", "", "<init>", "(Lokio/Sink;JLkotlin/jvm/functions/Function0;)V", "bytesWritten", "write", "source", "Lokio/Buffer;", "byteCount", "close", "flush", "timeout", "Lokio/Timeout;", "mockwebserver3"})
public final class TriggerSink
implements Sink {
    @NotNull
    private final Sink delegate;
    private final long triggerByteCount;
    @NotNull
    private final Function0<Unit> trigger;
    private long bytesWritten;

    public TriggerSink(@NotNull Sink delegate, long triggerByteCount, @NotNull Function0<Unit> trigger) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(trigger, (String)"trigger");
        this.delegate = delegate;
        this.triggerByteCount = triggerByteCount;
        this.trigger = trigger;
    }

    public void write(@NotNull Buffer source, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (byteCount == 0L) {
            return;
        }
        if (this.bytesWritten == this.triggerByteCount) {
            source.skip(byteCount);
            return;
        }
        long toWrite = Math.min(byteCount, this.triggerByteCount - this.bytesWritten);
        this.bytesWritten += toWrite;
        this.delegate.write(source, toWrite);
        if (this.bytesWritten == this.triggerByteCount) {
            this.trigger.invoke();
        }
        source.skip(byteCount - toWrite);
    }

    public void flush() {
        this.delegate.flush();
    }

    @NotNull
    public Timeout timeout() {
        return this.delegate.timeout();
    }

    public void close() {
        this.delegate.close();
    }
}

