/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import java.lang.reflect.Proxy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.ObjectsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\r\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0001J\u0013\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\u0013\u0010\u0013\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\u0013\u0010\u0014\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\u001d\u0010\u0015\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lleakcanary/internal/VisibilityTracker;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Landroid/content/BroadcastReceiver;", "listener", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "hasVisibleActivities", "lastUpdate", "screenOn", "startedActivityCount", "", "onActivityCreated", "p0", "Landroid/app/Activity;", "p1", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "onActivityStarted", "activity", "onActivityStopped", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "updateVisible", "leakcanary-android-core_release"})
public final class VisibilityTracker
extends BroadcastReceiver
implements Application.ActivityLifecycleCallbacks {
    private int startedActivityCount;
    private boolean hasVisibleActivities;
    private boolean screenOn;
    private boolean lastUpdate;
    private final Function1<Boolean, Unit> listener;
    private final /* synthetic */ Application.ActivityLifecycleCallbacks $$delegate_0;

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        int n = this.startedActivityCount;
        this.startedActivityCount = n + 1;
        if (!this.hasVisibleActivities && this.startedActivityCount == 1) {
            this.hasVisibleActivities = true;
            this.updateVisible();
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (this.startedActivityCount > 0) {
            int n = this.startedActivityCount;
            this.startedActivityCount = n + -1;
        }
        if (this.hasVisibleActivities && this.startedActivityCount == 0 && !activity.isChangingConfigurations()) {
            this.hasVisibleActivities = false;
            this.updateVisible();
        }
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        this.screenOn = Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.intent.action.SCREEN_OFF") ^ true;
        this.updateVisible();
    }

    private final void updateVisible() {
        boolean visible;
        boolean bl = visible = this.screenOn && this.hasVisibleActivities;
        if (visible != this.lastUpdate) {
            this.lastUpdate = visible;
            this.listener.invoke((Object)visible);
        }
    }

    public VisibilityTracker(@NotNull Function1<? super Boolean, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        boolean $i$f$noOpDelegate = false;
        boolean $i$f$noOpDelegate2 = false;
        Class<Application.ActivityLifecycleCallbacks> javaClass$iv$iv = Application.ActivityLifecycleCallbacks.class;
        Object object = Proxy.newProxyInstance(javaClass$iv$iv.getClassLoader(), new Class[]{javaClass$iv$iv}, ObjectsKt.access$getNO_OP_HANDLER$p());
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Application.ActivityLifecycleCallbacks");
        }
        this.$$delegate_0 = (Application.ActivityLifecycleCallbacks)object;
        this.listener = listener;
        this.screenOn = true;
    }

    public void onActivityCreated(@NonNull @NotNull Activity p0, @Nullable @org.jetbrains.annotations.Nullable Bundle p1) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        this.$$delegate_0.onActivityCreated(p0, p1);
    }

    public void onActivityDestroyed(@NonNull @NotNull Activity p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        this.$$delegate_0.onActivityDestroyed(p0);
    }

    public void onActivityPaused(@NonNull @NotNull Activity p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        this.$$delegate_0.onActivityPaused(p0);
    }

    public void onActivityResumed(@NonNull @NotNull Activity p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        this.$$delegate_0.onActivityResumed(p0);
    }

    public void onActivitySaveInstanceState(@NonNull @NotNull Activity p0, @NonNull @NotNull Bundle p1) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
        this.$$delegate_0.onActivitySaveInstanceState(p0, p1);
    }
}

