/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import org.assertj.android.api.widget.AbstractTextViewAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class AutoCompleteTextViewAssert
extends AbstractTextViewAssert<AutoCompleteTextViewAssert, AutoCompleteTextView> {
    public AutoCompleteTextViewAssert(AutoCompleteTextView actual) {
        super(actual, AutoCompleteTextViewAssert.class);
    }

    public AutoCompleteTextViewAssert hasEnoughToFilter() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AutoCompleteTextView)this.actual).enoughToFilter()).overridingErrorMessage("Expected to have enough to filter but did not.", new Object[0])).isTrue();
        return this;
    }

    public AutoCompleteTextViewAssert hasAdapter(ListAdapter adapter) {
        this.isNotNull();
        ListAdapter actualAdapter = ((AutoCompleteTextView)this.actual).getAdapter();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualAdapter).overridingErrorMessage("Expected adapter <%s> but was <%s>.", new Object[]{adapter, actualAdapter})).isSameAs((Object)adapter);
        return this;
    }

    @TargetApi(value=16)
    public AutoCompleteTextViewAssert hasCompletionHint(CharSequence hint) {
        this.isNotNull();
        CharSequence actualHint = ((AutoCompleteTextView)this.actual).getCompletionHint();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualHint).overridingErrorMessage("Expected completion hint <%s> but was <%s>.", new Object[]{hint, actualHint})).isEqualTo((Object)hint);
        return this;
    }

    public AutoCompleteTextViewAssert hasCompletionHint(int resId) {
        this.isNotNull();
        return this.hasCompletionHint(((AutoCompleteTextView)this.actual).getContext().getString(resId));
    }

    public AutoCompleteTextViewAssert hasDropDownAnchor(int id) {
        this.isNotNull();
        int actualId = ((AutoCompleteTextView)this.actual).getDropDownAnchor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected drop-down anchor ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public AutoCompleteTextViewAssert hasDropDownBackground(Drawable background) {
        this.isNotNull();
        Drawable actualBackground = ((AutoCompleteTextView)this.actual).getDropDownBackground();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBackground).overridingErrorMessage("Expected drop-down background <%s> but was <%s>.", new Object[]{background, actualBackground})).isSameAs((Object)background);
        return this;
    }

    public AutoCompleteTextViewAssert hasDropDownHeight(int height) {
        this.isNotNull();
        int actualHeight = ((AutoCompleteTextView)this.actual).getDropDownHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected drop-down height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public AutoCompleteTextViewAssert hasDropDownHorizontalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((AutoCompleteTextView)this.actual).getDropDownHorizontalOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected drop-down horizontal offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public AutoCompleteTextViewAssert hasDropDownVerticalOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((AutoCompleteTextView)this.actual).getDropDownVerticalOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected drop-down vertical offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public AutoCompleteTextViewAssert hasDropDownWidth(int width) {
        this.isNotNull();
        int actualWidth = ((AutoCompleteTextView)this.actual).getDropDownWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected drop-down width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public AutoCompleteTextViewAssert hasListSelection(int position) {
        this.isNotNull();
        int actualPosition = ((AutoCompleteTextView)this.actual).getListSelection();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected list selection position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    public AutoCompleteTextViewAssert hasThreshold(int threshold) {
        this.isNotNull();
        int actualThreshold = ((AutoCompleteTextView)this.actual).getThreshold();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualThreshold).overridingErrorMessage("Expected threshold <%s> but was <%s>.", new Object[]{threshold, actualThreshold})).isEqualTo(threshold);
        return this;
    }

    public AutoCompleteTextViewAssert isPerformingCompletion() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AutoCompleteTextView)this.actual).isPerformingCompletion()).overridingErrorMessage("Expected to be performing completion but was not.", new Object[0])).isTrue();
        return this;
    }

    public AutoCompleteTextViewAssert isNotPerformingCompletion() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AutoCompleteTextView)this.actual).isPerformingCompletion()).overridingErrorMessage("Expected to not be performing completion but was.", new Object[0])).isFalse();
        return this;
    }

    public AutoCompleteTextViewAssert isShowingPopup() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AutoCompleteTextView)this.actual).isPopupShowing()).overridingErrorMessage("Expected popup to be showing but was not showing.", new Object[0])).isTrue();
        return this;
    }

    public AutoCompleteTextViewAssert isNotShowingPopup() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AutoCompleteTextView)this.actual).isPopupShowing()).overridingErrorMessage("Expected popup to not be showing but was showing.", new Object[0])).isFalse();
        return this;
    }
}

