/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.animation;

import android.annotation.TargetApi;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractAnimationAssert<S extends AbstractAnimationAssert<S, A>, A extends Animation>
extends AbstractAssert<S, A> {
    protected AbstractAnimationAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    @TargetApi(value=12)
    public S hasBackgroundColor(int color) {
        this.isNotNull();
        int actualColor = ((Animation)this.actual).getBackgroundColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected background color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasDuration(long duration) {
        this.isNotNull();
        long actualDuration = ((Animation)this.actual).getDuration();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isFillingAfter() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).getFillAfter()).overridingErrorMessage("Expected to be filling after but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotFillingAfter() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).getFillAfter()).overridingErrorMessage("Expected to not be filling after but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isFillingBefore() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).getFillBefore()).overridingErrorMessage("Expected to be filling before but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotFillingBefore() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).getFillBefore()).overridingErrorMessage("Expected to not be filling before but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasInterpolator(Interpolator interpolator) {
        this.isNotNull();
        Interpolator actualInterpolator = ((Animation)this.actual).getInterpolator();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasRepeatCount(int count) {
        this.isNotNull();
        int actualCount = ((Animation)this.actual).getRepeatCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected repeat count <%s> but was <%s>.", new Object[]{AbstractAnimationAssert.repeatCountToString(count), AbstractAnimationAssert.repeatCountToString(actualCount)})).isEqualTo(count);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasRepeatMode(int mode) {
        this.isNotNull();
        int actualMode = ((Animation)this.actual).getRepeatMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected repeat mode <%s> but was <%s>.", new Object[]{AbstractAnimationAssert.repeatModeToString(mode), AbstractAnimationAssert.repeatModeToString(actualMode)})).isEqualTo(mode);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasStartOffset(long offset) {
        this.isNotNull();
        long actualOffset = ((Animation)this.actual).getStartOffset();
        ((AbstractLongAssert)Assertions.assertThat((long)actualOffset).overridingErrorMessage("Expected start offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasStartTime(long time) {
        this.isNotNull();
        long actualTime = ((Animation)this.actual).getStartTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected start time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(actualTime);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S hasZAdjustment(int adjustment) {
        this.isNotNull();
        int actualAdjustment = ((Animation)this.actual).getZAdjustment();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAdjustment).overridingErrorMessage("Expected Z adjustment <%s> but was <%s>.", new Object[]{adjustment, actualAdjustment})).isEqualTo(adjustment);
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isEnded() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).hasEnded()).overridingErrorMessage("Expected to be ended but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotEnded() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).hasEnded()).overridingErrorMessage("Expected to not be ended but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isStarted() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).hasStarted()).overridingErrorMessage("Expected to be started but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotStarted() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).hasStarted()).overridingErrorMessage("Expected to not be started but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isFillEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).isFillEnabled()).overridingErrorMessage("Expected fill to be enabled but was disabled.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isFillDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).isFillEnabled()).overridingErrorMessage("Expected fill to be disabled but was enabled.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isInitialized() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).isInitialized()).overridingErrorMessage("Expected to be initialized but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotInitialized() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).isInitialized()).overridingErrorMessage("Expected to not be initialized but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isChangingBounds() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).willChangeBounds()).overridingErrorMessage("Expected to be changing bounds but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotChangingBounds() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).willChangeBounds()).overridingErrorMessage("Expected to not be changing bounds but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isChangingTransformationMatrix() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).willChangeTransformationMatrix()).overridingErrorMessage("Expected to be changing bounds but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public S isNotChangingTransformationMatrix() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Animation)this.actual).willChangeTransformationMatrix()).overridingErrorMessage("Expected to not be changing bounds but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimationAssert)this.myself));
    }

    public static String repeatCountToString(int count) {
        return IntegerUtils.buildNamedValueString(count).value(-1, "infinite").getOrValue();
    }

    public static String repeatModeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(1, "restart").value(2, "reverse").get();
    }
}

