/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.KeyCharacterMap;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class KeyCharacterMapAssert
extends AbstractAssert<KeyCharacterMapAssert, KeyCharacterMap> {
    public KeyCharacterMapAssert(KeyCharacterMap actual) {
        super((Object)actual, KeyCharacterMapAssert.class);
    }

    public KeyCharacterMapAssert hasKeyboardType(int type) {
        this.isNotNull();
        int actualType = ((KeyCharacterMap)this.actual).getKeyboardType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected keyboard type <%s> but was <%s>.", new Object[]{KeyCharacterMapAssert.keyboardTypeToString(type), KeyCharacterMapAssert.keyboardTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    @TargetApi(value=11)
    public KeyCharacterMapAssert hasModifierBehavior(int value) {
        this.isNotNull();
        int actualValue = ((KeyCharacterMap)this.actual).getModifierBehavior();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualValue).overridingErrorMessage("Expected modifier behavior <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }

    public static String keyboardTypeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(1, "numeric").value(2, "predicive").value(3, "alpha").value(4, "full").value(5, "specialFunction").get();
    }
}

