/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.util;

import android.util.AttributeSet;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class AttributeSetAssert
extends AbstractAssert<AttributeSetAssert, AttributeSet> {
    public AttributeSetAssert(AttributeSet actual) {
        super((Object)actual, AttributeSetAssert.class);
    }

    public AttributeSetAssert hasAttributeCount(int count) {
        this.isNotNull();
        int actualCount = ((AttributeSet)this.actual).getAttributeCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected attribute count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AttributeSetAssert hasClassAttribute(String value) {
        this.isNotNull();
        String actualValue = ((AttributeSet)this.actual).getClassAttribute();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualValue).overridingErrorMessage("Expected class attribute value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo((Object)value);
        return this;
    }

    public AttributeSetAssert hasIdAttribute(String value) {
        this.isNotNull();
        String actualValue = ((AttributeSet)this.actual).getIdAttribute();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualValue).overridingErrorMessage("Exepcted ID attribute value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo((Object)value);
        return this;
    }

    public AttributeSetAssert hasPositionDescription(String position) {
        this.isNotNull();
        String actualPosition = ((AttributeSet)this.actual).getPositionDescription();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPosition).overridingErrorMessage("Expected position description <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo((Object)position);
        return this;
    }

    public AttributeSetAssert hasStyleAttribute(int value) {
        this.isNotNull();
        int actualValue = ((AttributeSet)this.actual).getStyleAttribute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualValue).overridingErrorMessage("Expected style attribute value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }
}

