/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.telephony;

import android.annotation.TargetApi;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class TelephonyManagerAssert
extends AbstractAssert<TelephonyManagerAssert, TelephonyManager> {
    public TelephonyManagerAssert(TelephonyManager actual) {
        super((Object)actual, TelephonyManagerAssert.class);
    }

    public TelephonyManagerAssert hasCallState(int state) {
        this.isNotNull();
        int actualState = ((TelephonyManager)this.actual).getCallState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected call state <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.callStateToString(state), TelephonyManagerAssert.callStateToString(actualState)})).isEqualTo(state);
        return this;
    }

    public TelephonyManagerAssert hasCellLocation(CellLocation cellLocation) {
        this.isNotNull();
        CellLocation actualCellLocation = ((TelephonyManager)this.actual).getCellLocation();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualCellLocation).overridingErrorMessage("Expected cell location <%s> but was <%s>.", new Object[]{cellLocation, actualCellLocation})).isEqualTo((Object)cellLocation);
        return this;
    }

    public TelephonyManagerAssert hasDataActivity(int dataActivity) {
        this.isNotNull();
        int actualDataActivity = ((TelephonyManager)this.actual).getDataActivity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDataActivity).overridingErrorMessage("Expected data activity <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.dataActivityToString(dataActivity), TelephonyManagerAssert.dataActivityToString(actualDataActivity)})).isEqualTo(dataActivity);
        return this;
    }

    public TelephonyManagerAssert hasDataState(int dataState) {
        this.isNotNull();
        int actualDataState = ((TelephonyManager)this.actual).getDataState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDataState).overridingErrorMessage("Expected data state <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.dataStateToString(dataState), TelephonyManagerAssert.dataStateToString(actualDataState)})).isEqualTo(dataState);
        return this;
    }

    public TelephonyManagerAssert hasDeviceId(String deviceId) {
        this.isNotNull();
        String actualDeviceId = ((TelephonyManager)this.actual).getDeviceId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualDeviceId).overridingErrorMessage("Expected device ID <%s> but was <%s>.", new Object[]{deviceId, actualDeviceId})).isEqualTo((Object)deviceId);
        return this;
    }

    public TelephonyManagerAssert hasDeviceSoftwareVersion(String version) {
        this.isNotNull();
        String actualVersion = ((TelephonyManager)this.actual).getDeviceSoftwareVersion();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualVersion).overridingErrorMessage("Expected device software version <%s> but was <%s>.", new Object[]{version, actualVersion})).isEqualTo((Object)version);
        return this;
    }

    @TargetApi(value=18)
    public TelephonyManagerAssert hasGroupIdLevel1(String level) {
        this.isNotNull();
        String actualLevel = ((TelephonyManager)this.actual).getGroupIdLevel1();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualLevel).overridingErrorMessage("Expected group ID level 1 <%s> but was <%s>.", new Object[]{level, actualLevel})).isEqualTo((Object)level);
        return this;
    }

    public TelephonyManagerAssert hasLine1Number(String number) {
        this.isNotNull();
        String actualNumber = ((TelephonyManager)this.actual).getLine1Number();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualNumber).overridingErrorMessage("Expected line 1 number <%s> but was <%s>.", new Object[]{number, actualNumber})).isEqualTo((Object)number);
        return this;
    }

    @TargetApi(value=19)
    public TelephonyManagerAssert hasMmsUAProfUrl(String url) {
        this.isNotNull();
        String actualUrl = ((TelephonyManager)this.actual).getMmsUAProfUrl();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUrl).overridingErrorMessage("Expected MMS user agent profile URL <%s> but was <%s>.", new Object[]{url, actualUrl})).isEqualTo((Object)url);
        return this;
    }

    @TargetApi(value=19)
    public TelephonyManagerAssert hasMmsUserAgent(String userAgent) {
        this.isNotNull();
        String actualUserAgent = ((TelephonyManager)this.actual).getMmsUserAgent();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUserAgent).overridingErrorMessage("Expected MMS user agent <%s> but was <%s>.", new Object[]{userAgent, actualUserAgent})).isEqualTo((Object)userAgent);
        return this;
    }

    public TelephonyManagerAssert hasNetworkCountryIso(String iso) {
        this.isNotNull();
        String actualIso = ((TelephonyManager)this.actual).getNetworkCountryIso();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualIso).overridingErrorMessage("Expected network country ISO <%s> but was <%s>.", new Object[]{iso, actualIso})).isEqualTo((Object)iso);
        return this;
    }

    public TelephonyManagerAssert hasNetworkOperator(String operator) {
        this.isNotNull();
        String actualOperator = ((TelephonyManager)this.actual).getNetworkOperator();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualOperator).overridingErrorMessage("Expected network operator <%s> but was <%s>.", new Object[]{operator, actualOperator})).isEqualTo((Object)operator);
        return this;
    }

    public TelephonyManagerAssert hasNetworkOperatorName(String name) {
        this.isNotNull();
        String actualName = ((TelephonyManager)this.actual).getNetworkOperatorName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected network operator name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public TelephonyManagerAssert hasNetworkType(int type) {
        this.isNotNull();
        int actualType = ((TelephonyManager)this.actual).getNetworkType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected network type <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.networkTypeToString(type), TelephonyManagerAssert.networkTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public TelephonyManagerAssert hasPhoneType(int type) {
        this.isNotNull();
        int actualType = ((TelephonyManager)this.actual).getPhoneType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected phone type <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.phoneTypeToString(type), TelephonyManagerAssert.phoneTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public TelephonyManagerAssert hasSimCountryIso(String iso) {
        this.isNotNull();
        String actualIso = ((TelephonyManager)this.actual).getSimCountryIso();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualIso).overridingErrorMessage("Expected SIM country ISO <%s> but was <%s>.", new Object[]{iso, actualIso})).isEqualTo((Object)iso);
        return this;
    }

    public TelephonyManagerAssert hasSimOperator(String operator) {
        this.isNotNull();
        String actualOperator = ((TelephonyManager)this.actual).getSimOperator();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualOperator).overridingErrorMessage("Expected SIM operator <%s> but was <%s>.", new Object[]{operator, actualOperator})).isEqualTo((Object)operator);
        return this;
    }

    public TelephonyManagerAssert hasSimOperatorName(String name) {
        this.isNotNull();
        String actualName = ((TelephonyManager)this.actual).getSimOperatorName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected SIM operator name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public TelephonyManagerAssert hasSimSerialNumber(String serialNumber) {
        this.isNotNull();
        String actualSerialNumber = ((TelephonyManager)this.actual).getSimSerialNumber();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualSerialNumber).overridingErrorMessage("Expected SIM serial number <%s> but was <%s>.", new Object[]{serialNumber, actualSerialNumber})).isEqualTo((Object)serialNumber);
        return this;
    }

    public TelephonyManagerAssert hasSimState(int state) {
        this.isNotNull();
        int actualState = ((TelephonyManager)this.actual).getSimState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected SIM state <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.simStateToString(state), TelephonyManagerAssert.simStateToString(actualState)})).isEqualTo(state);
        return this;
    }

    public TelephonyManagerAssert hasSubscriberId(String id) {
        this.isNotNull();
        String actualId = ((TelephonyManager)this.actual).getSubscriberId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualId).overridingErrorMessage("Expected subscriber ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo((Object)id);
        return this;
    }

    public TelephonyManagerAssert hasVoiceMailAlphaTag(String tag) {
        this.isNotNull();
        String actualTag = ((TelephonyManager)this.actual).getVoiceMailAlphaTag();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualTag).overridingErrorMessage("Expected voice mail alpha tag <%s> but was <%s>.", new Object[]{tag, actualTag})).isEqualTo((Object)tag);
        return this;
    }

    public TelephonyManagerAssert hasVoiceMailNumber(String number) {
        this.isNotNull();
        String actualNumber = ((TelephonyManager)this.actual).getVoiceMailNumber();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualNumber).overridingErrorMessage("Expected voice mail number <%s> but was <%s>.", new Object[]{number, actualNumber})).isEqualTo((Object)number);
        return this;
    }

    public TelephonyManagerAssert hasIccCard() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TelephonyManager)this.actual).hasIccCard()).overridingErrorMessage("Expected an ICC card to be present but was not.", new Object[0])).isTrue();
        return this;
    }

    public TelephonyManagerAssert doesNotHaveIccCard() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TelephonyManager)this.actual).hasIccCard()).overridingErrorMessage("Expected an ICC card to not be present but was.", new Object[0])).isFalse();
        return this;
    }

    public TelephonyManagerAssert isNetworkRoaming() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TelephonyManager)this.actual).isNetworkRoaming()).overridingErrorMessage("Expected the device to be considered roaming but was not.", new Object[0])).isTrue();
        return this;
    }

    public TelephonyManagerAssert isNotNetworkRoaming() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TelephonyManager)this.actual).isNetworkRoaming()).overridingErrorMessage("Expected the device to not be considered roaming but was.", new Object[0])).isFalse();
        return this;
    }

    public static String callStateToString(int callState) {
        return IntegerUtils.buildNamedValueString(callState).value(0, "idle").value(2, "offhook").value(1, "ringing").get();
    }

    public static String dataActivityToString(int dataActivity) {
        return IntegerUtils.buildNamedValueString(dataActivity).value(4, "dormant").value(1, "in").value(3, "inout").value(0, "none").value(2, "out").get();
    }

    public static String dataStateToString(int dataState) {
        return IntegerUtils.buildNamedValueString(dataState).value(2, "connected").value(1, "connecting").value(0, "disconnected").value(3, "suspended").get();
    }

    public static String networkTypeToString(int networkType) {
        return IntegerUtils.buildNamedValueString(networkType).value(7, "1xRTT").value(4, "cdma").value(2, "edge").value(14, "ehrpd").value(5, "evdo_0").value(6, "evdo_A").value(12, "evdo_b").value(1, "gprs").value(8, "hsdpa").value(10, "hspa").value(15, "hspap").value(9, "hsupa").value(11, "iden").value(13, "lte").value(3, "umts").value(0, "uknown").get();
    }

    public static String phoneTypeToString(int phoneType) {
        return IntegerUtils.buildNamedValueString(phoneType).value(2, "cdma").value(1, "gsm").value(0, "none").value(3, "sip").get();
    }

    public static String simStateToString(int simState) {
        return IntegerUtils.buildNamedValueString(simState).value(1, "absent").value(4, "network_locked").value(2, "pin_required").value(3, "puk_required").value(5, "ready").value(0, "uknown").get();
    }
}

