/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.telephony;

import android.annotation.TargetApi;
import android.telephony.CellIdentityCdma;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=17)
public class CellIdentityCdmaAssert
extends AbstractAssert<CellIdentityCdmaAssert, CellIdentityCdma> {
    public CellIdentityCdmaAssert(CellIdentityCdma actual) {
        super((Object)actual, CellIdentityCdmaAssert.class);
    }

    public CellIdentityCdmaAssert hasBasestationId(int id) {
        this.isNotNull();
        int actualId = ((CellIdentityCdma)this.actual).getBasestationId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected base station ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public CellIdentityCdmaAssert hasLatitude(int latitude) {
        this.isNotNull();
        int actualLatitude = ((CellIdentityCdma)this.actual).getLatitude();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLatitude).overridingErrorMessage("Expected latitude <%s> but was <%s>.", new Object[]{latitude, actualLatitude})).isEqualTo(latitude);
        return this;
    }

    public CellIdentityCdmaAssert hasLongitude(int longitude) {
        this.isNotNull();
        int actualLongitude = ((CellIdentityCdma)this.actual).getLongitude();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLongitude).overridingErrorMessage("Expected longitude <%s> but was <%s>.", new Object[]{longitude, actualLongitude})).isEqualTo(longitude);
        return this;
    }

    public CellIdentityCdmaAssert hasNetworkId(int id) {
        this.isNotNull();
        int actualId = ((CellIdentityCdma)this.actual).getNetworkId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected network ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public CellIdentityCdmaAssert hasSystemId(int id) {
        this.isNotNull();
        int actualId = ((CellIdentityCdma)this.actual).getSystemId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected system ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }
}

