/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.hardware.usb;

import android.annotation.TargetApi;
import android.hardware.usb.UsbInterface;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=12)
public class UsbInterfaceAssert
extends AbstractAssert<UsbInterfaceAssert, UsbInterface> {
    public UsbInterfaceAssert(UsbInterface actual) {
        super((Object)actual, UsbInterfaceAssert.class);
    }

    public UsbInterfaceAssert hasEndpointCount(int count) {
        this.isNotNull();
        int actualCount = ((UsbInterface)this.actual).getEndpointCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected endpoint count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public UsbInterfaceAssert hasId(int id) {
        this.isNotNull();
        int actualId = ((UsbInterface)this.actual).getId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected id <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public UsbInterfaceAssert hasInterfaceClass(int interfaceClass) {
        this.isNotNull();
        int actualInterfaceClass = ((UsbInterface)this.actual).getInterfaceClass();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualInterfaceClass).overridingErrorMessage("Expected interface class <%s> but was <%s>.", new Object[]{interfaceClass, actualInterfaceClass})).isEqualTo(interfaceClass);
        return this;
    }

    public UsbInterfaceAssert hasInterfaceProtocol(int protocol) {
        this.isNotNull();
        int actualProtocol = ((UsbInterface)this.actual).getInterfaceProtocol();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualProtocol).overridingErrorMessage("Expected interface protocol <%s> but was <%s>.", new Object[]{protocol, actualProtocol})).isEqualTo(protocol);
        return this;
    }

    public UsbInterfaceAssert hasInterfaceSubclass(int subclass) {
        this.isNotNull();
        int actualSubclass = ((UsbInterface)this.actual).getInterfaceSubclass();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSubclass).overridingErrorMessage("Expected interface subclass <%s> but was <%s>.", new Object[]{subclass, actualSubclass})).isEqualTo(subclass);
        return this;
    }
}

