/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.hardware.usb;

import android.annotation.TargetApi;
import android.hardware.usb.UsbDeviceConnection;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=12)
public class UsbDeviceConnectionAssert
extends AbstractAssert<UsbDeviceConnectionAssert, UsbDeviceConnection> {
    public UsbDeviceConnectionAssert(UsbDeviceConnection actual) {
        super((Object)actual, UsbDeviceConnectionAssert.class);
    }

    public UsbDeviceConnectionAssert hasFileDescriptor(int descriptor) {
        this.isNotNull();
        int actualDescriptor = ((UsbDeviceConnection)this.actual).getFileDescriptor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDescriptor).overridingErrorMessage("Expected file descriptor <%s> but was <%s>.", new Object[]{descriptor, actualDescriptor})).isEqualTo(descriptor);
        return this;
    }

    @TargetApi(value=13)
    public UsbDeviceConnectionAssert hasRawDescriptors(byte[] descriptors) {
        this.isNotNull();
        byte[] actualDescriptors = ((UsbDeviceConnection)this.actual).getRawDescriptors();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualDescriptors).overridingErrorMessage("Expected raw descriptors <%s> but was <%s>.", new Object[]{descriptors, actualDescriptors})).isEqualTo((Object)descriptors);
        return this;
    }

    public UsbDeviceConnectionAssert hasSerial(String serial) {
        this.isNotNull();
        String actualSerial = ((UsbDeviceConnection)this.actual).getSerial();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualSerial).overridingErrorMessage("Expected serial <%s> but was <%s>.", new Object[]{serial, actualSerial})).isEqualTo((Object)serial);
        return this;
    }
}

