/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.annotation.TargetApi;
import android.graphics.YuvImage;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=8)
public class YuvImageAssert
extends AbstractAssert<YuvImageAssert, YuvImage> {
    public YuvImageAssert(YuvImage actual) {
        super((Object)actual, YuvImageAssert.class);
    }

    public YuvImageAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((YuvImage)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public YuvImageAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((YuvImage)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public YuvImageAssert hasYuvFormat(int format) {
        this.isNotNull();
        int actualFormat = ((YuvImage)this.actual).getYuvFormat();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFormat).overridingErrorMessage("Expected YUV format <%s> but was <%s>.", new Object[]{format, actualFormat})).isEqualTo(format);
        return this;
    }
}

