/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import org.assertj.android.api.graphics.RectAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class RegionAssert
extends AbstractAssert<RegionAssert, Region> {
    public RegionAssert(Region actual) {
        super((Object)actual, RectAssert.class);
    }

    public RegionAssert hasBoundaryPath(Path path) {
        this.isNotNull();
        Path actualPath = ((Region)this.actual).getBoundaryPath();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualPath).overridingErrorMessage("Expected boundary path <%s> but was <%s>.", new Object[]{path, actualPath})).isEqualTo((Object)path);
        return this;
    }

    public RegionAssert hasBounds(Rect bounds) {
        this.isNotNull();
        Rect actualBounds = ((Region)this.actual).getBounds();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBounds).overridingErrorMessage("Expected bounds <%s> but was <%s>.", new Object[]{bounds, actualBounds})).isEqualTo((Object)bounds);
        return this;
    }

    public RegionAssert isComplex() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Region)this.actual).isComplex()).overridingErrorMessage("Expected to be complex but was not.", new Object[0])).isTrue();
        return this;
    }

    public RegionAssert isNotComplex() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Region)this.actual).isComplex()).overridingErrorMessage("Expected to not be complex but was.", new Object[0])).isFalse();
        return this;
    }

    public RegionAssert isEmpty() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Region)this.actual).isEmpty()).overridingErrorMessage("Expected to be empty but was not.", new Object[0])).isTrue();
        return this;
    }

    public RegionAssert isNotEmpty() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Region)this.actual).isEmpty()).overridingErrorMessage("Expected to not be empty but was.", new Object[0])).isFalse();
        return this;
    }

    public RegionAssert isRect() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Region)this.actual).isRect()).overridingErrorMessage("Expected to be a rectangle but was not.", new Object[0])).isTrue();
        return this;
    }

    public RegionAssert isNotRect() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Region)this.actual).isRect()).overridingErrorMessage("Expected to not be a rectangle but was.", new Object[0])).isTrue();
        return this;
    }
}

