/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class BitmapAssert
extends AbstractAssert<BitmapAssert, Bitmap> {
    public BitmapAssert(Bitmap actual) {
        super((Object)actual, BitmapAssert.class);
    }

    public BitmapAssert isRecycled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isRecycled()).overridingErrorMessage("Expected to be recycled but was not recycled.", new Object[0])).isTrue();
        return this;
    }

    public BitmapAssert isNotRecycled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isRecycled()).overridingErrorMessage("Expected to not be recycled but was recycled.", new Object[0])).isFalse();
        return this;
    }

    public BitmapAssert isMutable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isMutable()).overridingErrorMessage("Expected to be mutable but was not mutable.", new Object[0])).isTrue();
        return this;
    }

    public BitmapAssert isNotMutable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isMutable()).overridingErrorMessage("Expected to not be mutable but was mutable.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=17)
    public BitmapAssert isPremultiplied() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isPremultiplied()).overridingErrorMessage("Expected to be premultiplied but was not premultiplied.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=17)
    public BitmapAssert isNotPremultiplied() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isPremultiplied()).overridingErrorMessage("Expected to not be premultiplied but was premultiplied.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=19)
    public BitmapAssert hasAllocationByteCount(int count) {
        this.isNotNull();
        int actualCount = ((Bitmap)this.actual).getAllocationByteCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected allocation byte count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @TargetApi(value=12)
    public BitmapAssert hasByteCount(int count) {
        this.isNotNull();
        int actualCount = ((Bitmap)this.actual).getByteCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected byte count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public BitmapAssert hasDensity(int density) {
        this.isNotNull();
        int actualDensity = ((Bitmap)this.actual).getDensity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDensity).overridingErrorMessage("Expected density <%s> but was <%s>.", new Object[]{density, actualDensity})).isEqualTo(density);
        return this;
    }

    public BitmapAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Bitmap)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public BitmapAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Bitmap)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public BitmapAssert hasAlphaSupport() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).hasAlpha()).overridingErrorMessage("Expected to have alpha support but did not have it.", new Object[0])).isTrue();
        return this;
    }

    public BitmapAssert hasNoAlphaSupport() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).hasAlpha()).overridingErrorMessage("Expected to not have alpha support but had it.", new Object[0])).isFalse();
        return this;
    }
}

