/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.codegen.ksp;

import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.Visibility;
import com.squareup.anvil.compiler.UtilsKt;
import com.squareup.anvil.compiler.codegen.ksp.KSAnnotationExtensionsKt;
import com.squareup.anvil.compiler.codegen.ksp.KspAnvilException;
import com.squareup.anvil.compiler.codegen.ksp.KspUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001e\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0080\b\u00f8\u0001\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0000\u001a\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"checkClassExtendsBoundType", "", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "checkClassIsPublic", "message", "Lkotlin/Function0;", "", "checkNotMoreThanOneMapKey", "checkNotMoreThanOneQualifier", "checkSingleSuperType", "isInterface", "", "superTypesExcludingAny", "Lkotlin/sequences/Sequence;", "Lcom/google/devtools/ksp/symbol/KSTypeReference;", "compiler"})
@SourceDebugExtension(value={"SMAP\nKSClassDeclarationExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KSClassDeclarationExtensions.kt\ncom/squareup/anvil/compiler/codegen/ksp/KSClassDeclarationExtensionsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1268#2,3:114\n1774#3,4:117\n*S KotlinDebug\n*F\n+ 1 KSClassDeclarationExtensions.kt\ncom/squareup/anvil/compiler/codegen/ksp/KSClassDeclarationExtensionsKt\n*L\n20#1:114,3\n45#1:117,4\n*E\n"})
public final class KSClassDeclarationExtensionsKt {
    public static final void checkNotMoreThanOneQualifier(@NotNull KSClassDeclaration $this$checkNotMoreThanOneQualifier, @NotNull FqName annotationFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNotMoreThanOneQualifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        List annotationsList = SequencesKt.toList((Sequence)$this$checkNotMoreThanOneQualifier.getAnnotations());
        if (annotationsList.size() <= 2) {
            return;
        }
        Sequence $this$count$iv = $this$checkNotMoreThanOneQualifier.getAnnotations();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            KSAnnotation it = (KSAnnotation)element$iv;
            boolean bl = false;
            if (!KSAnnotationExtensionsKt.isQualifier(it) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int qualifierCount = count$iv;
        if (qualifierCount > 1) {
            throw new KspAnvilException("Classes annotated with @" + annotationFqName.shortName() + " may not use more than one @Qualifier.", (KSNode)$this$checkNotMoreThanOneQualifier, null, 4, null);
        }
    }

    public static final void checkClassIsPublic(@NotNull KSClassDeclaration $this$checkClassIsPublic, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)$this$checkClassIsPublic, (String)"<this>");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$checkClassIsPublic = false;
        if (com.google.devtools.ksp.UtilsKt.getVisibility((KSDeclaration)((KSDeclaration)$this$checkClassIsPublic)) != Visibility.PUBLIC) {
            throw new KspAnvilException((String)message.invoke(), (KSNode)$this$checkClassIsPublic, null, 4, null);
        }
    }

    public static final void checkNotMoreThanOneMapKey(@NotNull KSClassDeclaration $this$checkNotMoreThanOneMapKey) {
        int mapKeysCount;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$checkNotMoreThanOneMapKey, (String)"<this>");
        List annotationsList = SequencesKt.toList((Sequence)$this$checkNotMoreThanOneMapKey.getAnnotations());
        if (annotationsList.size() <= 2) {
            return;
        }
        Iterable $this$count$iv = annotationsList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KSAnnotation it = (KSAnnotation)element$iv;
                boolean bl = false;
                if (!KSAnnotationExtensionsKt.isMapKey(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = mapKeysCount = count$iv;
        }
        if (mapKeysCount > 1) {
            throw new KspAnvilException("Classes annotated with @" + UtilsKt.getContributesMultibindingFqName().shortName() + " may not use more than one @MapKey.", (KSNode)$this$checkNotMoreThanOneMapKey, null, 4, null);
        }
    }

    public static final void checkSingleSuperType(@NotNull KSClassDeclaration $this$checkSingleSuperType, @NotNull FqName annotationFqName, @NotNull Resolver resolver) {
        boolean hasExplicitBoundType;
        Intrinsics.checkNotNullParameter((Object)$this$checkSingleSuperType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        KSAnnotated kSAnnotated = (KSAnnotated)$this$checkSingleSuperType;
        String string = annotationFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        KSAnnotation kSAnnotation = (KSAnnotation)SequencesKt.firstOrNull(KspUtilKt.getKSAnnotationsByQualifiedName(kSAnnotated, string));
        boolean bl = hasExplicitBoundType = (kSAnnotation != null ? KSAnnotationExtensionsKt.boundTypeOrNull(kSAnnotation) : null) != null;
        if (hasExplicitBoundType) {
            return;
        }
        if (SequencesKt.count(KSClassDeclarationExtensionsKt.superTypesExcludingAny($this$checkSingleSuperType, resolver)) != 1) {
            KSName kSName = $this$checkSingleSuperType.getQualifiedName();
            throw new KspAnvilException((kSName != null ? kSName.asString() : null) + " contributes a binding, but does not specify the bound type. This is only allowed with exactly one direct super type. If there are multiple or none, then the bound type must be explicitly defined in the @" + annotationFqName.shortName() + " annotation.", (KSNode)$this$checkSingleSuperType, null, 4, null);
        }
    }

    public static final void checkClassExtendsBoundType(@NotNull KSClassDeclaration $this$checkClassExtendsBoundType, @NotNull FqName annotationFqName, @NotNull Resolver resolver) {
        KSType kSType;
        KSType kSType2;
        Intrinsics.checkNotNullParameter((Object)$this$checkClassExtendsBoundType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        KSAnnotated kSAnnotated = (KSAnnotated)$this$checkClassExtendsBoundType;
        String string = annotationFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        KSAnnotation kSAnnotation = (KSAnnotation)SequencesKt.firstOrNull(KspUtilKt.getKSAnnotationsByQualifiedName(kSAnnotated, string));
        if (kSAnnotation != null && (kSType2 = KSAnnotationExtensionsKt.boundTypeOrNull(kSAnnotation)) != null) {
            kSType = kSType2;
        } else {
            KSTypeReference kSTypeReference = (KSTypeReference)SequencesKt.singleOrNull(KSClassDeclarationExtensionsKt.superTypesExcludingAny($this$checkClassExtendsBoundType, resolver));
            if (kSTypeReference != null) {
                kSType = kSTypeReference.resolve();
            } else {
                throw new KspAnvilException("Couldn't find the bound type.", (KSNode)$this$checkClassExtendsBoundType, null, 4, null);
            }
        }
        KSType boundType = kSType;
        if (Intrinsics.areEqual((Object)boundType, (Object)resolver.getBuiltIns().getAnyType())) {
            return;
        }
        if (!boundType.isAssignableFrom($this$checkClassExtendsBoundType.asType(CollectionsKt.emptyList()))) {
            KSName kSName = $this$checkClassExtendsBoundType.getQualifiedName();
            KSName kSName2 = boundType.getDeclaration().getQualifiedName();
            throw new KspAnvilException((kSName != null ? kSName.asString() : null) + " contributes a binding for " + (kSName2 != null ? kSName2.asString() : null) + ", but doesn't extend this type.", (KSNode)$this$checkClassExtendsBoundType, null, 4, null);
        }
    }

    @NotNull
    public static final Sequence<KSTypeReference> superTypesExcludingAny(@NotNull KSClassDeclaration $this$superTypesExcludingAny, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypesExcludingAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return SequencesKt.filterNot((Sequence)$this$superTypesExcludingAny.getSuperTypes(), (Function1)((Function1)new Function1<KSTypeReference, Boolean>(resolver){
            final /* synthetic */ Resolver $resolver;
            {
                this.$resolver = $resolver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KSTypeReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.resolve(), (Object)this.$resolver.getBuiltIns().getAnyType());
            }
        }));
    }

    public static final boolean isInterface(@NotNull KSClassDeclaration $this$isInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"<this>");
        return $this$isInterface.getClassKind() == ClassKind.INTERFACE;
    }
}

