/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifiers;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractChangeNotifier<T>
implements ChangeNotifier<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractChangeNotifier.class);
    private final AtomicReference<ChangeNotifier.Listener<T>> listenerRef = new AtomicReference();
    private final AtomicBoolean listenerNotified = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();

    AbstractChangeNotifier() {
    }

    @Override
    public void setListener(ChangeNotifier.Listener<T> listener, boolean fire) {
        Preconditions.checkNotNull(listener, (Object)"listener");
        this.lock.lock();
        try {
            if (!this.listenerRef.compareAndSet(null, listener)) {
                throw new IllegalStateException("Listener already set!");
            }
            if (fire) {
                this.notifyListener(this.newChangeNotification(this.current(), Collections.emptySet()), true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void close() {
        this.listenerRef.set(null);
        this.closeImplementation();
    }

    protected abstract void closeImplementation();

    protected final void fireRecordsUpdated(ChangeNotifier.ChangeNotification<T> changeNotification) {
        this.notifyListener(changeNotification, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(ChangeNotifier.ChangeNotification<T> changeNotification, boolean newListener) {
        block6: {
            this.lock.lock();
            try {
                Preconditions.checkNotNull(changeNotification, (Object)"changeNotification");
                ChangeNotifier.Listener<T> listener = this.listenerRef.get();
                if (listener == null) break block6;
                try {
                    boolean notified = this.listenerNotified.getAndSet(true);
                    if (!newListener || !notified) {
                        listener.onChange(changeNotification);
                    }
                }
                catch (Throwable e) {
                    log.error("Change notification listener threw exception", e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected final ChangeNotifier.ChangeNotification<T> newChangeNotification(Set<T> current, Set<T> previous) {
        Preconditions.checkNotNull(current, (Object)"current");
        Preconditions.checkNotNull(previous, (Object)"previous");
        return new ChangeNotificationImpl<T>(current, previous);
    }

    private static class ChangeNotificationImpl<T>
    implements ChangeNotifier.ChangeNotification<T> {
        private final Set<T> current;
        private final Set<T> previous;

        protected ChangeNotificationImpl(Set<T> current, Set<T> previous) {
            this.current = current;
            this.previous = previous;
        }

        @Override
        public Set<T> current() {
            return this.unmodifiable(this.current);
        }

        private Set<T> unmodifiable(Set<T> set) {
            if (ChangeNotifiers.isInitialEmptyData(set)) {
                return set;
            }
            if (set instanceof ImmutableSet) {
                return set;
            }
            return Collections.unmodifiableSet(set);
        }

        @Override
        public Set<T> previous() {
            return this.unmodifiable(this.previous);
        }
    }
}

