/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenExchangeResponse {
    private final boolean mIsSuccess;
    private final String mAccessToken;
    private final String mTokenType;
    private final int mExpiresIn;
    private final String mScope;
    private final String mRefreshToken;
    private final String mError;
    private final String mErrorDescription;

    private TokenExchangeResponse(boolean isSuccess, @Nullable String accessToken, @Nullable String tokenType, int expiresIn, @Nullable String scope, @Nullable String refreshToken, @Nullable String error, @Nullable String errorDescription) {
        this.mIsSuccess = isSuccess;
        this.mAccessToken = accessToken;
        this.mTokenType = tokenType;
        this.mExpiresIn = expiresIn;
        this.mScope = scope;
        this.mRefreshToken = refreshToken;
        this.mError = error;
        this.mErrorDescription = errorDescription;
    }

    public boolean isSuccess() {
        return this.mIsSuccess;
    }

    @Nullable
    public String getAccessToken() {
        return this.mAccessToken;
    }

    @Nullable
    public String getTokenType() {
        return this.mTokenType;
    }

    public int getExpiresIn() {
        return this.mExpiresIn;
    }

    @Nullable
    public String getScope() {
        return this.mScope;
    }

    @Nullable
    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    @Nullable
    public String getError() {
        return this.mError;
    }

    @Nullable
    public String getErrorDescription() {
        return this.mErrorDescription;
    }

    @NonNull
    static TokenExchangeResponse fromHttpResponse(int responseCode, @Nullable String responseBody) {
        if (responseBody == null || responseBody.trim().isEmpty()) {
            return TokenExchangeResponse.fromError("invalid_response", "Empty response body");
        }
        try {
            JSONObject json = new JSONObject(responseBody);
            if (responseCode == 200) {
                String accessToken = json.optString("access_token", null);
                String tokenType = json.optString("token_type", null);
                int expiresIn = json.optInt("expires_in", 0);
                String scope = json.optString("scope", null);
                String refreshToken = json.optString("refresh_token", null);
                if (accessToken == null || accessToken.isEmpty()) {
                    return TokenExchangeResponse.fromError("invalid_response", "Missing access_token in response");
                }
                return TokenExchangeResponse.fromSuccess(accessToken, tokenType, expiresIn, scope, refreshToken);
            }
            String error = json.optString("error", "unknown_error");
            String errorDescription = json.optString("error_description", null);
            return TokenExchangeResponse.fromError(error, errorDescription);
        }
        catch (JSONException e) {
            return TokenExchangeResponse.fromError("invalid_response", "Invalid JSON response: " + e.getMessage());
        }
    }

    @NonNull
    static TokenExchangeResponse fromSuccess(@NonNull String accessToken, @Nullable String tokenType, int expiresIn, @Nullable String scope, @Nullable String refreshToken) {
        return new TokenExchangeResponse(true, accessToken, tokenType, expiresIn, scope, refreshToken, null, null);
    }

    @NonNull
    static TokenExchangeResponse fromError(@NonNull String error, @Nullable String errorDescription) {
        return new TokenExchangeResponse(false, null, null, 0, null, null, error, errorDescription);
    }
}

