/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.util.Base64;
import androidx.annotation.NonNull;
import com.spotify.sdk.android.auth.PKCEInformation;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PKCEInformationFactory {
    private static final int CODE_VERIFIER_LENGTH = 128;
    private static final String CODE_VERIFIER_CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~";

    @NonNull
    public static PKCEInformation create() throws NoSuchAlgorithmException {
        String codeVerifier = PKCEInformationFactory.generateCodeVerifier();
        String codeChallenge = PKCEInformationFactory.generateCodeChallenge(codeVerifier);
        return PKCEInformation.sha256(codeVerifier, codeChallenge);
    }

    @NonNull
    private static String generateCodeVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder codeVerifier = new StringBuilder();
        for (int i = 0; i < 128; ++i) {
            int randomIndex = secureRandom.nextInt(CODE_VERIFIER_CHARSET.length());
            codeVerifier.append(CODE_VERIFIER_CHARSET.charAt(randomIndex));
        }
        return codeVerifier.toString();
    }

    @NonNull
    private static String generateCodeChallenge(@NonNull String codeVerifier) throws NoSuchAlgorithmException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(codeVerifier.getBytes("US-ASCII"));
            return Base64.encodeToString((byte[])hash, (int)11);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported", e);
        }
    }
}

