/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Objects;

public class PKCEInformation
implements Parcelable {
    private final String mVerifier;
    private final String mChallenge;
    private final String mCodeChallengeMethod;
    public static final Parcelable.Creator<PKCEInformation> CREATOR = new Parcelable.Creator<PKCEInformation>(){

        @NonNull
        public PKCEInformation createFromParcel(@NonNull Parcel in) {
            return new PKCEInformation(in);
        }

        @NonNull
        public PKCEInformation[] newArray(int size) {
            return new PKCEInformation[size];
        }
    };

    private PKCEInformation(@NonNull String verifier, @NonNull String challenge, @NonNull String challengeMethod) {
        this.mVerifier = verifier;
        this.mChallenge = challenge;
        this.mCodeChallengeMethod = challengeMethod;
    }

    @NonNull
    public static PKCEInformation sha256(@NonNull String verifier, @NonNull String challenge) {
        return new PKCEInformation(verifier, challenge, "S256");
    }

    @NonNull
    public String getVerifier() {
        return this.mVerifier;
    }

    @NonNull
    public String getChallenge() {
        return this.mChallenge;
    }

    @NonNull
    public String getCodeChallengeMethod() {
        return this.mCodeChallengeMethod;
    }

    private PKCEInformation(@NonNull Parcel in) {
        this.mVerifier = in.readString();
        this.mChallenge = in.readString();
        this.mCodeChallengeMethod = in.readString();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mVerifier);
        dest.writeString(this.mChallenge);
        dest.writeString(this.mCodeChallengeMethod);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PKCEInformation that = (PKCEInformation)o;
        return Objects.equals(this.mVerifier, that.mVerifier) && Objects.equals(this.mChallenge, that.mChallenge) && Objects.equals(this.mCodeChallengeMethod, that.mCodeChallengeMethod);
    }

    public int hashCode() {
        return Objects.hash(this.mVerifier, this.mChallenge, this.mCodeChallengeMethod);
    }
}

