/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.browser;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.spotify.sdk.android.auth.AuthorizationHandler;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.R;
import java.util.ArrayList;
import java.util.List;

public class LoginDialog
extends Dialog {
    private static final String TAG = LoginDialog.class.getName();
    public static final int CUSTOM_TAB_HIDDEN = 6;
    private static final int DEFAULT_THEME = 0x1030010;
    private final Uri mUri;
    private final String mRedirectUri;
    @Nullable
    private AuthorizationHandler.OnCompleteListener mListener;
    private ProgressDialog mProgressDialog;
    private boolean mAttached;
    private boolean mResultDelivered;
    private CustomTabsSession mTabsSession;
    private CustomTabsServiceConnection mTabConnection;

    public LoginDialog(Activity contextActivity, AuthorizationRequest request) {
        this(contextActivity, 0x1030010, request);
    }

    public LoginDialog(Activity contextActivity, int theme, AuthorizationRequest request) {
        super((Context)contextActivity, theme);
        this.mUri = request.toUri();
        this.mRedirectUri = request.getRedirectUri();
    }

    public void setOnCompleteListener(@Nullable AuthorizationHandler.OnCompleteListener listener) {
        this.mListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mResultDelivered = false;
        this.mProgressDialog = new ProgressDialog(this.getContext());
        this.mProgressDialog.setMessage((CharSequence)this.getContext().getString(R.string.com_spotify_sdk_login_progress));
        this.mProgressDialog.requestWindowFeature(1);
        this.mProgressDialog.setOnCancelListener(dialogInterface -> this.dismiss());
        this.setContentView(R.layout.com_spotify_sdk_login_dialog);
        String packageSupportingCustomTabs = this.getPackageNameSupportingCustomTabs(this.mUri);
        if (TextUtils.isEmpty((CharSequence)packageSupportingCustomTabs) || this.mRedirectUri.startsWith("http") || this.mRedirectUri.startsWith("https")) {
            Log.d((String)TAG, (String)"No package supporting CustomTabs found, launching browser fallback.");
            this.launchAuthInBrowserFallback();
        } else {
            Log.d((String)TAG, (String)("Launching auth in CustomTabs supporting package:" + packageSupportingCustomTabs));
            this.launchAuthInCustomTabs(packageSupportingCustomTabs);
        }
    }

    private String getPackageNameSupportingCustomTabs(Uri uri) {
        PackageManager pm = this.getContext().getPackageManager();
        Intent activityIntent = new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE");
        ResolveInfo defaultViewHandlerInfo = pm.resolveActivity(activityIntent, 0);
        String defaultViewHandlerPackageName = null;
        if (defaultViewHandlerInfo != null) {
            defaultViewHandlerPackageName = defaultViewHandlerInfo.activityInfo.packageName;
        }
        Log.d((String)TAG, (String)("Found default package name for handling VIEW intents: " + defaultViewHandlerPackageName));
        List resolvedActivityList = pm.queryIntentActivities(activityIntent, 0);
        ArrayList<String> packagesSupportingCustomTabs = new ArrayList<String>();
        for (ResolveInfo info : resolvedActivityList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
            serviceIntent.setPackage(info.activityInfo.packageName);
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            Log.d((String)TAG, (String)("Adding " + info.activityInfo.packageName + " to supported packages"));
            packagesSupportingCustomTabs.add(info.activityInfo.packageName);
        }
        String packageNameToUse = null;
        if (packagesSupportingCustomTabs.size() == 1) {
            packageNameToUse = (String)packagesSupportingCustomTabs.get(0);
        } else if (packagesSupportingCustomTabs.size() > 1) {
            packageNameToUse = !TextUtils.isEmpty((CharSequence)defaultViewHandlerPackageName) && packagesSupportingCustomTabs.contains(defaultViewHandlerPackageName) ? defaultViewHandlerPackageName : (String)packagesSupportingCustomTabs.get(0);
        }
        return packageNameToUse;
    }

    private void launchAuthInBrowserFallback() {
        if (this.internetPermissionNotGranted()) {
            Log.e((String)TAG, (String)"Missing INTERNET permission");
        }
        this.getContext().startActivity(new Intent("android.intent.action.VIEW", this.mUri));
    }

    private void launchAuthInCustomTabs(String packageName) {
        if (this.internetPermissionNotGranted()) {
            Log.e((String)TAG, (String)"Missing INTERNET permission");
        }
        this.mTabConnection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(@NonNull ComponentName name, @NonNull CustomTabsClient client) {
                client.warmup(0L);
                LoginDialog.this.mTabsSession = client.newSession((CustomTabsCallback)new AuthCustomTabsCallback());
                if (LoginDialog.this.mTabsSession != null) {
                    CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setSession(LoginDialog.this.mTabsSession).build();
                    customTabsIntent.launchUrl(LoginDialog.this.getContext(), LoginDialog.this.mUri);
                } else {
                    LoginDialog.this.unbindCustomTabsService();
                    Log.i((String)TAG, (String)"Auth using CustomTabs aborted, reason: CustomTabsSession is null. Launching auth in browser instead.");
                    LoginDialog.this.launchAuthInBrowserFallback();
                }
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        CustomTabsClient.bindCustomTabsService((Context)this.getContext(), (String)packageName, (CustomTabsServiceConnection)this.mTabConnection);
    }

    public void unbindCustomTabsService() {
        if (this.mTabConnection == null) {
            return;
        }
        this.getContext().unbindService((ServiceConnection)this.mTabConnection);
        this.mTabsSession = null;
        this.mTabConnection = null;
    }

    public void onAttachedToWindow() {
        this.mAttached = true;
        super.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        this.mAttached = false;
        super.onDetachedFromWindow();
    }

    protected void onStop() {
        AuthorizationHandler.OnCompleteListener listener = this.mListener;
        if (!this.mResultDelivered && listener != null) {
            listener.onCancel();
        }
        this.mResultDelivered = true;
        this.mProgressDialog.dismiss();
        this.unbindCustomTabsService();
        super.onStop();
    }

    public void close() {
        if (this.mAttached) {
            this.dismiss();
        }
    }

    private boolean internetPermissionNotGranted() {
        String packageName;
        PackageManager pm = this.getContext().getPackageManager();
        return pm.checkPermission("android.permission.INTERNET", packageName = this.getContext().getPackageName()) != 0;
    }

    class AuthCustomTabsCallback
    extends CustomTabsCallback {
        AuthCustomTabsCallback() {
        }

        public void onNavigationEvent(int navigationEvent, @Nullable Bundle extras) {
            super.onNavigationEvent(navigationEvent, extras);
            if (navigationEvent == 6) {
                LoginDialog.this.close();
            }
        }
    }
}

