/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.spotify.sdk.android.auth.AuthorizationClient;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.AuthorizationResponse;
import com.spotify.sdk.android.auth.R;

public class LoginActivity
extends Activity
implements AuthorizationClient.AuthorizationClientListener {
    static final String EXTRA_REPLY = "REPLY";
    static final String EXTRA_ERROR = "ERROR";
    static final String RESPONSE_TYPE_TOKEN = "token";
    static final String RESPONSE_TYPE_CODE = "code";
    private static final String TAG = LoginActivity.class.getName();
    private static final String NO_CALLER_ERROR = "Can't use LoginActivity with a null caller. Possible reasons: calling activity has a singleInstance mode or LoginActivity is in a singleInstance/singleTask mode";
    private static final String NO_REQUEST_ERROR = "No authorization request";
    static final String EXTRA_AUTH_REQUEST = "EXTRA_AUTH_REQUEST";
    static final String EXTRA_AUTH_RESPONSE = "EXTRA_AUTH_RESPONSE";
    public static final String REQUEST_KEY = "request";
    public static final String RESPONSE_KEY = "response";
    private AuthorizationClient mAuthorizationClient = new AuthorizationClient(this);
    public static final int REQUEST_CODE = 1138;
    private static final int RESULT_ERROR = -2;

    public static Intent getAuthIntent(Activity contextActivity, AuthorizationRequest request) {
        if (contextActivity == null || request == null) {
            throw new IllegalArgumentException("Context activity or request can't be null");
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(REQUEST_KEY, (Parcelable)request);
        Intent intent = new Intent((Context)contextActivity, LoginActivity.class);
        intent.putExtra(EXTRA_AUTH_REQUEST, bundle);
        return intent;
    }

    static AuthorizationResponse getResponseFromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        Bundle responseBundle = intent.getBundleExtra(EXTRA_AUTH_RESPONSE);
        if (responseBundle == null) {
            return null;
        }
        return (AuthorizationResponse)responseBundle.getParcelable(RESPONSE_KEY);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_spotify_sdk_login_activity);
        AuthorizationRequest request = this.getRequestFromIntent();
        this.mAuthorizationClient.setOnCompleteListener(this);
        if (this.getCallingActivity() == null) {
            Log.e((String)TAG, (String)NO_CALLER_ERROR);
            this.finish();
        } else if (request == null) {
            Log.e((String)TAG, (String)NO_REQUEST_ERROR);
            this.setResult(0);
            this.finish();
        } else if (savedInstanceState == null) {
            Log.d((String)TAG, (String)String.format("Spotify Auth starting with the request [%s]", request.toUri().toString()));
            this.mAuthorizationClient.authorize(request);
        }
    }

    private AuthorizationRequest getRequestFromIntent() {
        Bundle requestBundle = this.getIntent().getBundleExtra(EXTRA_AUTH_REQUEST);
        if (requestBundle == null) {
            return null;
        }
        return (AuthorizationRequest)requestBundle.getParcelable(REQUEST_KEY);
    }

    protected void onDestroy() {
        this.mAuthorizationClient.cancel();
        this.mAuthorizationClient.setOnCompleteListener(null);
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (requestCode == 1138) {
            AuthorizationResponse.Builder response = new AuthorizationResponse.Builder();
            if (resultCode == -2) {
                response.setType(AuthorizationResponse.Type.ERROR);
                String errorMessage = intent == null ? "Invalid message format" : intent.getStringExtra(EXTRA_ERROR);
                if (errorMessage == null) {
                    errorMessage = "Unknown error";
                }
                response.setError(errorMessage);
            } else if (resultCode == -1) {
                Bundle data = (Bundle)intent.getParcelableExtra(EXTRA_REPLY);
                if (data == null) {
                    response.setType(AuthorizationResponse.Type.ERROR);
                    response.setError("Missing response data");
                } else {
                    String responseType = data.getString("RESPONSE_TYPE", "unknown");
                    Log.d((String)TAG, (String)("Response: " + responseType));
                    response.setState(data.getString("STATE", null));
                    switch (responseType) {
                        case "token": {
                            String token = data.getString("ACCESS_TOKEN");
                            int expiresIn = data.getInt("EXPIRES_IN");
                            response.setType(AuthorizationResponse.Type.TOKEN);
                            response.setAccessToken(token);
                            response.setExpiresIn(expiresIn);
                            break;
                        }
                        case "code": {
                            String code = data.getString("AUTHORIZATION_CODE");
                            response.setType(AuthorizationResponse.Type.CODE);
                            response.setCode(code);
                            break;
                        }
                        default: {
                            response.setType(AuthorizationResponse.Type.UNKNOWN);
                        }
                    }
                }
            } else {
                response.setType(AuthorizationResponse.Type.EMPTY);
            }
            this.mAuthorizationClient.setOnCompleteListener(this);
            this.mAuthorizationClient.complete(response.build());
        }
    }

    @Override
    public void onClientComplete(AuthorizationResponse response) {
        Intent resultIntent = new Intent();
        Log.i((String)TAG, (String)String.format("Spotify auth completing. The response is in EXTRA with key '%s'", RESPONSE_KEY));
        Bundle bundle = new Bundle();
        bundle.putParcelable(RESPONSE_KEY, (Parcelable)response);
        resultIntent.putExtra(EXTRA_AUTH_RESPONSE, bundle);
        this.setResult(-1, resultIntent);
        this.finish();
    }

    @Override
    public void onClientCancelled() {
        Log.w((String)TAG, (String)"Spotify Auth cancelled due to LoginActivity being finished");
        this.setResult(0);
    }
}

