/*
 * Decompiled with CFR 0.152.
 */
package com.tokenautocomplete;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputMethodManager;
import android.widget.Filter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import com.tokenautocomplete.CharacterTokenizer;
import com.tokenautocomplete.CountSpan;
import com.tokenautocomplete.HintSpan;
import com.tokenautocomplete.Range;
import com.tokenautocomplete.SpanUtils;
import com.tokenautocomplete.Tokenizer;
import com.tokenautocomplete.ViewSpan;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class TokenCompleteTextView<T>
extends AppCompatAutoCompleteTextView
implements TextView.OnEditorActionListener,
ViewSpan.Layout {
    public static final String TAG = "TokenAutoComplete";
    private Tokenizer tokenizer;
    private T selectedObject;
    private TokenListener<T> listener;
    private TokenSpanWatcher spanWatcher;
    private TokenTextWatcher textWatcher;
    private CountSpan countSpan;
    @Nullable
    private SpannableStringBuilder hiddenContent;
    private TokenClickStyle tokenClickStyle = TokenClickStyle.None;
    private CharSequence prefix = "";
    private boolean hintVisible = false;
    private Layout lastLayout = null;
    private boolean initialized = false;
    private boolean performBestGuess = true;
    private boolean preventFreeFormText = true;
    private boolean savingState = false;
    private boolean shouldFocusNext = false;
    private boolean allowCollapse = true;
    private boolean internalEditInProgress = false;
    private int tokenLimit = -1;
    private transient String lastCompletionText = null;
    boolean inInvalidate = false;

    protected void addListeners() {
        Editable text = this.getText();
        if (text != null) {
            text.setSpan((Object)this.spanWatcher, 0, text.length(), 18);
            this.addTextChangedListener(this.textWatcher);
        }
    }

    protected void removeListeners() {
        Editable text = this.getText();
        if (text != null) {
            TokenSpanWatcher[] spanWatchers;
            for (TokenSpanWatcher watcher : spanWatchers = (TokenSpanWatcher[])text.getSpans(0, text.length(), TokenSpanWatcher.class)) {
                text.removeSpan((Object)watcher);
            }
            this.removeTextChangedListener(this.textWatcher);
        }
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.setTokenizer(new CharacterTokenizer(Arrays.asList(Character.valueOf(','), Character.valueOf(';')), ","));
        Editable text = this.getText();
        assert (null != text);
        this.spanWatcher = new TokenSpanWatcher();
        this.textWatcher = new TokenTextWatcher();
        this.hiddenContent = null;
        this.countSpan = new CountSpan();
        this.addListeners();
        this.setTextIsSelectable(false);
        this.setLongClickable(false);
        this.setInputType(this.getInputType() | 0x80000 | 0x10000);
        this.setHorizontallyScrolling(false);
        this.setOnEditorActionListener(this);
        this.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int destinationStart, int destinationEnd) {
                if (TokenCompleteTextView.this.internalEditInProgress) {
                    return null;
                }
                if (TokenCompleteTextView.this.tokenLimit != -1 && TokenCompleteTextView.this.getObjects().size() == TokenCompleteTextView.this.tokenLimit) {
                    return "";
                }
                if (TokenCompleteTextView.this.tokenizer.containsTokenTerminator(source) && (TokenCompleteTextView.this.preventFreeFormText || TokenCompleteTextView.this.currentCompletionText().length() > 0)) {
                    TokenCompleteTextView.this.performCompletion();
                    return "";
                }
                if (destinationStart < TokenCompleteTextView.this.prefix.length()) {
                    if (destinationStart == 0 && destinationEnd == 0) {
                        return null;
                    }
                    if (destinationEnd <= TokenCompleteTextView.this.prefix.length()) {
                        return TokenCompleteTextView.this.prefix.subSequence(destinationStart, destinationEnd);
                    }
                    return TokenCompleteTextView.this.prefix.subSequence(destinationStart, TokenCompleteTextView.this.prefix.length());
                }
                return null;
            }
        }});
        this.initialized = true;
    }

    public TokenCompleteTextView(Context context) {
        super(context);
        this.init();
    }

    public TokenCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TokenCompleteTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void performFiltering(CharSequence text, int keyCode) {
        Filter filter = this.getFilter();
        if (filter != null) {
            filter.filter((CharSequence)this.currentCompletionText(), (Filter.FilterListener)this);
        }
    }

    public void setTokenizer(Tokenizer t) {
        this.tokenizer = t;
    }

    public void setTokenClickStyle(TokenClickStyle cStyle) {
        this.tokenClickStyle = cStyle;
    }

    public void setTokenListener(TokenListener<T> l) {
        this.listener = l;
    }

    public boolean shouldIgnoreToken(T token) {
        return false;
    }

    public boolean isTokenRemovable(T token) {
        return true;
    }

    public void setPrefix(CharSequence p) {
        CharSequence prevPrefix = this.prefix;
        this.prefix = p;
        Editable text = this.getText();
        if (text != null) {
            this.internalEditInProgress = true;
            if (prevPrefix != null) {
                text.replace(0, prevPrefix.length(), p);
            } else {
                text.insert(0, p);
            }
            this.internalEditInProgress = false;
        }
        this.updateHint();
    }

    public void setPrefix(CharSequence prefix, int color) {
        SpannableString spannablePrefix = new SpannableString(prefix);
        spannablePrefix.setSpan((Object)new ForegroundColorSpan(color), 0, spannablePrefix.length(), 0);
        this.setPrefix((CharSequence)spannablePrefix);
    }

    public List<T> getObjects() {
        ArrayList objects = new ArrayList();
        Editable text = this.getText();
        if (this.hiddenContent != null) {
            text = this.hiddenContent;
        }
        for (TokenImageSpan span : (TokenImageSpan[])text.getSpans(0, text.length(), TokenImageSpan.class)) {
            objects.add(span.getToken());
        }
        return objects;
    }

    public CharSequence getContentText() {
        if (this.hiddenContent != null) {
            return this.hiddenContent;
        }
        return this.getText();
    }

    public void performBestGuess(boolean guess) {
        this.performBestGuess = guess;
    }

    public void preventFreeFormText(boolean prevent) {
        this.preventFreeFormText = prevent;
    }

    public void allowCollapse(boolean allowCollapse) {
        this.allowCollapse = allowCollapse;
    }

    public void setTokenLimit(int tokenLimit) {
        this.tokenLimit = tokenLimit;
    }

    protected abstract View getViewForObject(T var1);

    protected abstract T defaultObject(String var1);

    public CharSequence getTextForAccessibility() {
        int origSelectionEnd;
        int origSelectionStart;
        int i;
        if (this.getObjects().size() == 0) {
            return this.getText();
        }
        SpannableStringBuilder description = new SpannableStringBuilder();
        Editable text = this.getText();
        int selectionStart = -1;
        int selectionEnd = -1;
        for (i = 0; i < text.length(); ++i) {
            TokenImageSpan[] tokens;
            origSelectionStart = Selection.getSelectionStart((CharSequence)text);
            if (i == origSelectionStart) {
                selectionStart = description.length();
            }
            if (i == (origSelectionEnd = Selection.getSelectionEnd((CharSequence)text))) {
                selectionEnd = description.length();
            }
            if ((tokens = (TokenImageSpan[])text.getSpans(i, i, TokenImageSpan.class)).length > 0) {
                TokenImageSpan token = tokens[0];
                description = description.append(this.tokenizer.wrapTokenValue(token.getToken().toString()));
                i = text.getSpanEnd((Object)token);
                continue;
            }
            description = description.append(text.subSequence(i, i + 1));
        }
        origSelectionStart = Selection.getSelectionStart((CharSequence)text);
        if (i == origSelectionStart) {
            selectionStart = description.length();
        }
        if (i == (origSelectionEnd = Selection.getSelectionEnd((CharSequence)text))) {
            selectionEnd = description.length();
        }
        if (selectionStart >= 0 && selectionEnd >= 0) {
            Selection.setSelection((Spannable)description, (int)selectionStart, (int)selectionEnd);
        }
        return description;
    }

    public void clearCompletionText() {
        if (this.currentCompletionText().length() == 0) {
            return;
        }
        Range currentRange = this.getCurrentCandidateTokenRange();
        this.internalEditInProgress = true;
        this.getText().delete(currentRange.start, currentRange.end);
        this.internalEditInProgress = false;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 8192) {
            CharSequence text = this.getTextForAccessibility();
            event.setFromIndex(Selection.getSelectionStart((CharSequence)text));
            event.setToIndex(Selection.getSelectionEnd((CharSequence)text));
            event.setItemCount(text.length());
        }
    }

    private Range getCurrentCandidateTokenRange() {
        TokenImageSpan[] spans;
        Editable editable = this.getText();
        int cursorEndPosition = this.getSelectionEnd();
        int candidateStringStart = this.prefix.length();
        int candidateStringEnd = editable.length();
        if (this.hintVisible) {
            candidateStringEnd = candidateStringStart;
        }
        for (TokenImageSpan span : spans = (TokenImageSpan[])editable.getSpans(this.prefix.length(), editable.length(), TokenImageSpan.class)) {
            int spanStart;
            int spanEnd = editable.getSpanEnd((Object)span);
            if (candidateStringStart < spanEnd && cursorEndPosition >= spanEnd) {
                candidateStringStart = spanEnd;
            }
            if (candidateStringEnd <= (spanStart = editable.getSpanStart((Object)span)) || cursorEndPosition > spanEnd) continue;
            candidateStringEnd = spanStart;
        }
        List<Range> tokenRanges = this.tokenizer.findTokenRanges((CharSequence)editable, candidateStringStart, candidateStringEnd);
        for (Range range : tokenRanges) {
            if (range.start > cursorEndPosition || cursorEndPosition > range.end) continue;
            return range;
        }
        return new Range(cursorEndPosition, cursorEndPosition);
    }

    protected CharSequence tokenToString(T token) {
        return token.toString();
    }

    protected String currentCompletionText() {
        if (this.hintVisible) {
            return "";
        }
        Editable editable = this.getText();
        Range currentRange = this.getCurrentCandidateTokenRange();
        String result = TextUtils.substring((CharSequence)editable, (int)currentRange.start, (int)currentRange.end);
        Log.d((String)TAG, (String)("Current completion text: " + result));
        return result;
    }

    protected float maxTextWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    @Override
    public int getMaxViewSpanWidth() {
        return (int)this.maxTextWidth();
    }

    @TargetApi(value=16)
    private void api16Invalidate() {
        if (this.initialized && !this.inInvalidate) {
            this.inInvalidate = true;
            this.setShadowLayer(this.getShadowRadius(), this.getShadowDx(), this.getShadowDy(), this.getShadowColor());
            this.inInvalidate = false;
        }
    }

    public void invalidate() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.api16Invalidate();
        }
        super.invalidate();
    }

    public boolean enoughToFilter() {
        if (this.tokenizer == null || this.hintVisible) {
            return false;
        }
        int cursorPosition = this.getSelectionEnd();
        if (cursorPosition < 0) {
            return false;
        }
        Range currentCandidateRange = this.getCurrentCandidateTokenRange();
        return currentCandidateRange.length() >= Math.max(this.getThreshold(), 1);
    }

    public void performCompletion() {
        if ((this.getAdapter() == null || this.getListSelection() == -1) && this.enoughToFilter()) {
            Object bestGuess = this.getAdapter() != null && this.getAdapter().getCount() > 0 && this.performBestGuess ? this.getAdapter().getItem(0) : this.defaultObject(this.currentCompletionText());
            this.replaceText(this.convertSelectionToString(bestGuess));
        } else {
            super.performCompletion();
        }
    }

    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        InputConnection superConn = super.onCreateInputConnection(outAttrs);
        if (superConn != null) {
            TokenInputConnection conn = new TokenInputConnection(superConn, true);
            outAttrs.imeOptions &= 0xBFFFFFFF;
            outAttrs.imeOptions |= 0x10000000;
            return conn;
        }
        return null;
    }

    private void handleDone() {
        this.performCompletion();
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        boolean handled = super.onKeyUp(keyCode, event);
        if (this.shouldFocusNext) {
            this.shouldFocusNext = false;
            this.handleDone();
        }
        return handled;
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        boolean handled = false;
        switch (keyCode) {
            case 23: 
            case 61: 
            case 66: {
                if (!event.hasNoModifiers()) break;
                this.shouldFocusNext = true;
                handled = true;
                break;
            }
            case 67: {
                handled = !this.canDeleteSelection(1) || this.deleteSelectedObject();
            }
        }
        return handled || super.onKeyDown(keyCode, event);
    }

    private boolean deleteSelectedObject() {
        if (this.tokenClickStyle != null && this.tokenClickStyle.isSelectable()) {
            TokenImageSpan[] spans;
            Editable text = this.getText();
            if (text == null) {
                return false;
            }
            for (TokenImageSpan span : spans = (TokenImageSpan[])text.getSpans(0, text.length(), TokenImageSpan.class)) {
                if (!span.view.isSelected()) continue;
                this.removeSpan(text, span);
                return true;
            }
        }
        return false;
    }

    public boolean onEditorAction(TextView view, int action, KeyEvent keyEvent) {
        if (action == 6) {
            this.handleDone();
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int offset;
        int action = event.getActionMasked();
        Editable text = this.getText();
        boolean handled = false;
        if (this.tokenClickStyle == TokenClickStyle.None) {
            handled = super.onTouchEvent(event);
        }
        if (this.isFocused() && text != null && this.lastLayout != null && action == 1 && (offset = this.getOffsetForPosition(event.getX(), event.getY())) != -1) {
            TokenImageSpan[] links = (TokenImageSpan[])text.getSpans(offset, offset, TokenImageSpan.class);
            if (links.length > 0) {
                links[0].onClick();
                handled = true;
            } else {
                this.clearSelections();
            }
        }
        if (!handled && this.tokenClickStyle != TokenClickStyle.None) {
            handled = super.onTouchEvent(event);
        }
        return handled;
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        Editable text;
        if (this.hintVisible) {
            selStart = 0;
        }
        selEnd = selStart;
        if (this.tokenClickStyle != null && this.tokenClickStyle.isSelectable() && (text = this.getText()) != null) {
            this.clearSelections();
        }
        if (this.prefix != null && (selStart < this.prefix.length() || selEnd < this.prefix.length())) {
            this.setSelection(this.prefix.length());
        } else {
            text = this.getText();
            if (text != null) {
                TokenImageSpan[] spans;
                for (TokenImageSpan span : spans = (TokenImageSpan[])text.getSpans(selStart, selEnd, TokenImageSpan.class)) {
                    int spanEnd = text.getSpanEnd((Object)span);
                    if (selStart > spanEnd || text.getSpanStart((Object)span) >= selStart) continue;
                    if (spanEnd == text.length()) {
                        this.setSelection(spanEnd);
                    } else {
                        this.setSelection(spanEnd + 1);
                    }
                    return;
                }
            }
            super.onSelectionChanged(selStart, selEnd);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.lastLayout = this.getLayout();
    }

    public void performCollapse(boolean hasFocus) {
        this.internalEditInProgress = true;
        if (!hasFocus) {
            Editable text = this.getText();
            if (text != null && this.hiddenContent == null && this.lastLayout != null) {
                text.removeSpan((Object)this.spanWatcher);
                CountSpan temp = this.preventFreeFormText ? this.countSpan : null;
                Spanned ellipsized = SpanUtils.ellipsizeWithSpans(this.prefix, temp, this.getObjects().size(), this.lastLayout.getPaint(), (CharSequence)text, this.maxTextWidth());
                if (ellipsized != null) {
                    this.hiddenContent = new SpannableStringBuilder((CharSequence)text);
                    this.setText((CharSequence)ellipsized);
                    TextUtils.copySpansFrom((Spanned)ellipsized, (int)0, (int)ellipsized.length(), TokenImageSpan.class, (Spannable)this.getText(), (int)0);
                    TextUtils.copySpansFrom((Spanned)text, (int)0, (int)this.hiddenContent.length(), TokenImageSpan.class, (Spannable)this.hiddenContent, (int)0);
                    this.hiddenContent.setSpan((Object)this.spanWatcher, 0, this.hiddenContent.length(), 18);
                } else {
                    this.getText().setSpan((Object)this.spanWatcher, 0, this.getText().length(), 18);
                }
            }
        } else if (this.hiddenContent != null) {
            this.setText((CharSequence)this.hiddenContent);
            TextUtils.copySpansFrom((Spanned)this.hiddenContent, (int)0, (int)this.hiddenContent.length(), TokenImageSpan.class, (Spannable)this.getText(), (int)0);
            this.hiddenContent = null;
            if (this.hintVisible) {
                this.setSelection(this.prefix.length());
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        TokenCompleteTextView.this.setSelection(TokenCompleteTextView.this.getText().length());
                    }
                });
            }
            TokenSpanWatcher[] watchers = (TokenSpanWatcher[])this.getText().getSpans(0, this.getText().length(), TokenSpanWatcher.class);
            if (watchers.length == 0) {
                this.getText().setSpan((Object)this.spanWatcher, 0, this.getText().length(), 18);
            }
        }
        this.internalEditInProgress = false;
    }

    public void onFocusChanged(boolean hasFocus, int direction, Rect previous) {
        super.onFocusChanged(hasFocus, direction, previous);
        this.clearSelections();
        if (this.allowCollapse) {
            this.performCollapse(hasFocus);
        }
    }

    protected CharSequence convertSelectionToString(Object object) {
        this.selectedObject = object;
        return "";
    }

    protected TokenImageSpan buildSpanForObject(T obj) {
        if (obj == null) {
            return null;
        }
        View tokenView = this.getViewForObject(obj);
        return new TokenImageSpan(tokenView, obj);
    }

    protected void replaceText(CharSequence ignore) {
        this.clearComposingText();
        if (this.selectedObject == null || this.selectedObject.toString().equals("")) {
            return;
        }
        TokenImageSpan tokenSpan = this.buildSpanForObject(this.selectedObject);
        Editable editable = this.getText();
        Range candidateRange = this.getCurrentCandidateTokenRange();
        String original = TextUtils.substring((CharSequence)editable, (int)candidateRange.start, (int)candidateRange.end);
        if (original.length() > 0) {
            this.lastCompletionText = original;
        }
        if (editable != null) {
            this.internalEditInProgress = true;
            if (tokenSpan == null) {
                editable.replace(candidateRange.start, candidateRange.end, (CharSequence)"");
            } else if (this.shouldIgnoreToken(tokenSpan.getToken())) {
                editable.replace(candidateRange.start, candidateRange.end, (CharSequence)"");
                if (this.listener != null) {
                    this.listener.onTokenIgnored(tokenSpan.getToken());
                }
            } else {
                SpannableStringBuilder ssb = new SpannableStringBuilder(this.tokenizer.wrapTokenValue(this.tokenToString(tokenSpan.token)));
                editable.replace(candidateRange.start, candidateRange.end, (CharSequence)ssb);
                editable.setSpan((Object)tokenSpan, candidateRange.start, candidateRange.start + ssb.length(), 33);
                editable.insert(candidateRange.start + ssb.length(), (CharSequence)" ");
            }
            this.internalEditInProgress = false;
        }
    }

    public boolean extractText(@NonNull ExtractedTextRequest request, @NonNull ExtractedText outText) {
        try {
            return super.extractText(request, outText);
        }
        catch (IndexOutOfBoundsException ex) {
            Log.d((String)TAG, (String)"extractText hit IndexOutOfBoundsException. This may be normal.", (Throwable)ex);
            return false;
        }
    }

    @UiThread
    public void addObjectSync(T object) {
        if (object == null) {
            return;
        }
        if (this.shouldIgnoreToken(object)) {
            if (this.listener != null) {
                this.listener.onTokenIgnored(object);
            }
            return;
        }
        if (this.tokenLimit != -1 && this.getObjects().size() == this.tokenLimit) {
            return;
        }
        this.insertSpan(this.buildSpanForObject(object));
        if (this.getText() != null && this.isFocused()) {
            this.setSelection(this.getText().length());
        }
    }

    public void addObjectAsync(final T object) {
        this.post(new Runnable(){

            @Override
            public void run() {
                TokenCompleteTextView.this.addObjectSync(object);
            }
        });
    }

    @UiThread
    public void removeObjectSync(T object) {
        ArrayList<Object> texts = new ArrayList<Object>();
        if (this.hiddenContent != null) {
            texts.add(this.hiddenContent);
        }
        if (this.getText() != null) {
            texts.add(this.getText());
        }
        for (Editable editable : texts) {
            TokenImageSpan[] spans;
            for (TokenImageSpan span : spans = (TokenImageSpan[])editable.getSpans(0, editable.length(), TokenImageSpan.class)) {
                if (!span.getToken().equals(object)) continue;
                this.removeSpan(editable, span);
            }
        }
        this.updateCountSpan();
    }

    public void removeObjectAsync(final T object) {
        this.post(new Runnable(){

            @Override
            public void run() {
                TokenCompleteTextView.this.removeObjectSync(object);
            }
        });
    }

    public void clearAsync() {
        this.post(new Runnable(){

            @Override
            public void run() {
                for (Object object : TokenCompleteTextView.this.getObjects()) {
                    TokenCompleteTextView.this.removeObjectSync(object);
                }
            }
        });
    }

    private void updateCountSpan() {
        if (!this.preventFreeFormText) {
            return;
        }
        Editable text = this.getText();
        int visibleCount = ((TokenImageSpan[])this.getText().getSpans(0, this.getText().length(), TokenImageSpan.class)).length;
        this.countSpan.setCount(this.getObjects().size() - visibleCount);
        SpannableStringBuilder spannedCountText = new SpannableStringBuilder((CharSequence)this.countSpan.getCountText());
        spannedCountText.setSpan((Object)this.countSpan, 0, spannedCountText.length(), 33);
        this.internalEditInProgress = true;
        int countStart = text.getSpanStart((Object)this.countSpan);
        if (countStart != -1) {
            text.replace(countStart, text.getSpanEnd((Object)this.countSpan), (CharSequence)spannedCountText);
        } else {
            text.append((CharSequence)spannedCountText);
        }
        this.internalEditInProgress = false;
    }

    private void removeSpan(Editable text, TokenImageSpan span) {
        int end = text.getSpanEnd((Object)span);
        if (end < text.length() && text.charAt(end) == ' ') {
            ++end;
        }
        this.internalEditInProgress = true;
        text.delete(text.getSpanStart((Object)span), end);
        this.internalEditInProgress = false;
        if (this.allowCollapse && !this.isFocused()) {
            this.updateCountSpan();
        }
    }

    private void insertSpan(TokenImageSpan tokenSpan) {
        CharSequence ssb = this.tokenizer.wrapTokenValue(this.tokenToString(tokenSpan.token));
        Editable editable = this.getText();
        if (editable == null) {
            return;
        }
        if (this.hiddenContent == null) {
            this.internalEditInProgress = true;
            int offset = editable.length();
            if (this.hintVisible) {
                offset = this.prefix.length();
            } else {
                Range currentRange = this.getCurrentCandidateTokenRange();
                if (currentRange.length() > 0) {
                    offset = currentRange.start;
                }
            }
            editable.insert(offset, ssb);
            editable.insert(offset + ssb.length(), (CharSequence)" ");
            editable.setSpan((Object)tokenSpan, offset, offset + ssb.length(), 33);
            this.internalEditInProgress = false;
        } else {
            CharSequence tokenText = this.tokenizer.wrapTokenValue(this.tokenToString(tokenSpan.getToken()));
            int start = this.hiddenContent.length();
            this.hiddenContent.append(tokenText);
            this.hiddenContent.append((CharSequence)" ");
            this.hiddenContent.setSpan((Object)tokenSpan, start, start + tokenText.length(), 33);
            this.updateCountSpan();
        }
    }

    private void updateHint() {
        Editable text = this.getText();
        CharSequence hintText = this.getHint();
        if (text == null || hintText == null) {
            return;
        }
        if (this.prefix.length() > 0) {
            HintSpan[] hints = (HintSpan[])text.getSpans(0, text.length(), HintSpan.class);
            HintSpan hint = null;
            int testLength = this.prefix.length();
            if (hints.length > 0) {
                hint = hints[0];
                testLength += text.getSpanEnd((Object)hint) - text.getSpanStart((Object)hint);
            }
            if (text.length() == testLength) {
                this.hintVisible = true;
                if (hint != null) {
                    return;
                }
                Typeface tf = this.getTypeface();
                int style = 0;
                if (tf != null) {
                    style = tf.getStyle();
                }
                ColorStateList colors = this.getHintTextColors();
                HintSpan hintSpan = new HintSpan(null, style, (int)this.getTextSize(), colors, colors);
                this.internalEditInProgress = true;
                text.insert(this.prefix.length(), hintText);
                text.setSpan((Object)hintSpan, this.prefix.length(), this.prefix.length() + this.getHint().length(), 33);
                this.internalEditInProgress = false;
                this.setSelection(this.prefix.length());
            } else {
                if (hint == null) {
                    return;
                }
                int sStart = text.getSpanStart((Object)hint);
                int sEnd = text.getSpanEnd((Object)hint);
                this.internalEditInProgress = true;
                text.removeSpan((Object)hint);
                text.replace(sStart, sEnd, (CharSequence)"");
                this.internalEditInProgress = false;
                this.hintVisible = false;
            }
        }
    }

    private void clearSelections() {
        TokenImageSpan[] tokens;
        if (this.tokenClickStyle == null || !this.tokenClickStyle.isSelectable()) {
            return;
        }
        Editable text = this.getText();
        if (text == null) {
            return;
        }
        for (TokenImageSpan token : tokens = (TokenImageSpan[])text.getSpans(0, text.length(), TokenImageSpan.class)) {
            token.view.setSelected(false);
        }
        this.invalidate();
    }

    protected List<Serializable> getSerializableObjects() {
        ArrayList<Serializable> serializables = new ArrayList<Serializable>();
        for (T obj : this.getObjects()) {
            if (obj instanceof Serializable) {
                serializables.add((Serializable)obj);
                continue;
            }
            Log.e((String)TAG, (String)("Unable to save '" + obj + "'"));
        }
        if (serializables.size() != this.getObjects().size()) {
            String message = "You should make your objects Serializable or Parcelable or\noverride getSerializableObjects and convertSerializableArrayToObjectArray";
            Log.e((String)TAG, (String)message);
        }
        return serializables;
    }

    protected List<T> convertSerializableObjectsToTypedObjects(List s) {
        return s;
    }

    private Class reifyParameterizedTypeClass() {
        Class<?> viewClass = this.getClass();
        while (!viewClass.getSuperclass().equals(TokenCompleteTextView.class)) {
            viewClass = viewClass.getSuperclass();
        }
        ParameterizedType superclass = (ParameterizedType)viewClass.getGenericSuperclass();
        Type type = superclass.getActualTypeArguments()[0];
        return (Class)type;
    }

    public Parcelable onSaveInstanceState() {
        this.removeListeners();
        this.savingState = true;
        Parcelable superState = super.onSaveInstanceState();
        this.savingState = false;
        SavedState state = new SavedState(superState);
        state.prefix = this.prefix;
        state.allowCollapse = this.allowCollapse;
        state.performBestGuess = this.performBestGuess;
        state.preventFreeFormText = this.preventFreeFormText;
        state.tokenClickStyle = this.tokenClickStyle;
        Class parameterizedClass = this.reifyParameterizedTypeClass();
        if (Parcelable.class.isAssignableFrom(parameterizedClass)) {
            state.parcelableClassName = parameterizedClass.getName();
            state.baseObjects = this.getObjects();
        } else {
            state.parcelableClassName = "Serializable";
            state.baseObjects = this.getSerializableObjects();
        }
        state.tokenizer = this.tokenizer;
        this.addListeners();
        return state;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.internalEditInProgress = true;
        this.setText(ss.prefix);
        this.prefix = ss.prefix;
        this.internalEditInProgress = false;
        this.updateHint();
        this.allowCollapse = ss.allowCollapse;
        this.performBestGuess = ss.performBestGuess;
        this.preventFreeFormText = ss.preventFreeFormText;
        this.tokenClickStyle = ss.tokenClickStyle;
        this.tokenizer = ss.tokenizer;
        this.addListeners();
        List<Object> objects = "Serializable".equals(ss.parcelableClassName) ? this.convertSerializableObjectsToTypedObjects(ss.baseObjects) : ss.baseObjects;
        for (Object obj : objects) {
            this.addObjectSync(obj);
        }
        if (!this.isFocused() && this.allowCollapse) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    TokenCompleteTextView.this.performCollapse(TokenCompleteTextView.this.isFocused());
                }
            });
        }
    }

    public boolean canDeleteSelection(int beforeLength) {
        TokenImageSpan[] spans;
        if (this.getObjects().size() < 1) {
            return true;
        }
        int endSelection = this.getSelectionEnd();
        int startSelection = beforeLength == 1 ? this.getSelectionStart() : endSelection - beforeLength;
        Editable text = this.getText();
        for (TokenImageSpan span : spans = (TokenImageSpan[])text.getSpans(0, text.length(), TokenImageSpan.class)) {
            int startTokenSelection = text.getSpanStart((Object)span);
            int endTokenSelection = text.getSpanEnd((Object)span);
            if (this.isTokenRemovable(span.token) || !(startSelection == endSelection ? endTokenSelection + 1 == endSelection : startSelection <= startTokenSelection && endTokenSelection + 1 <= endSelection)) continue;
            return false;
        }
        return true;
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.lastCompletionText = null;
    }

    private class TokenInputConnection
    extends InputConnectionWrapper {
        TokenInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (!TokenCompleteTextView.this.canDeleteSelection(beforeLength)) {
                return false;
            }
            if (TokenCompleteTextView.this.getSelectionStart() <= TokenCompleteTextView.this.prefix.length()) {
                beforeLength = 0;
                return TokenCompleteTextView.this.deleteSelectedObject() || super.deleteSurroundingText(beforeLength, afterLength);
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        public boolean setComposingRegion(int start, int end) {
            if (TokenCompleteTextView.this.hintVisible) {
                end = 0;
                start = 0;
            }
            return super.setComposingRegion(start, end);
        }

        public boolean setComposingText(CharSequence text, int newCursorPosition) {
            String firstWord;
            CharSequence hint = TokenCompleteTextView.this.getHint();
            if (hint != null && text != null && (firstWord = hint.toString().trim().split(" ")[0]).length() > 0 && firstWord.equals(text.toString())) {
                text = "";
            }
            if (TokenCompleteTextView.this.lastCompletionText != null && text != null && text.length() == TokenCompleteTextView.this.lastCompletionText.length() + 1 && text.toString().startsWith(TokenCompleteTextView.this.lastCompletionText)) {
                text = text.subSequence(text.length() - 1, text.length());
            }
            return super.setComposingText(text, newCursorPosition);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        static final String SERIALIZABLE_PLACEHOLDER = "Serializable";
        CharSequence prefix;
        boolean allowCollapse;
        boolean performBestGuess;
        boolean preventFreeFormText;
        TokenClickStyle tokenClickStyle;
        String parcelableClassName;
        List<?> baseObjects;
        String tokenizerClassName;
        Tokenizer tokenizer;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcel in) {
            super(in);
            ClassLoader loader;
            this.prefix = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.allowCollapse = in.readInt() != 0;
            this.performBestGuess = in.readInt() != 0;
            this.preventFreeFormText = in.readInt() != 0;
            this.tokenClickStyle = TokenClickStyle.values()[in.readInt()];
            this.parcelableClassName = in.readString();
            if (SERIALIZABLE_PLACEHOLDER.equals(this.parcelableClassName)) {
                this.baseObjects = (ArrayList)in.readSerializable();
            } else {
                try {
                    loader = Class.forName(this.parcelableClassName).getClassLoader();
                    this.baseObjects = in.readArrayList(loader);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.tokenizerClassName = in.readString();
            try {
                loader = Class.forName(this.tokenizerClassName).getClassLoader();
                this.tokenizer = (Tokenizer)in.readParcelable(loader);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            TextUtils.writeToParcel((CharSequence)this.prefix, (Parcel)out, (int)0);
            out.writeInt(this.allowCollapse ? 1 : 0);
            out.writeInt(this.performBestGuess ? 1 : 0);
            out.writeInt(this.preventFreeFormText ? 1 : 0);
            out.writeInt(this.tokenClickStyle.ordinal());
            if (SERIALIZABLE_PLACEHOLDER.equals(this.parcelableClassName)) {
                out.writeString(SERIALIZABLE_PLACEHOLDER);
                out.writeSerializable((Serializable)((Object)this.baseObjects));
            } else {
                out.writeString(this.parcelableClassName);
                out.writeList(this.baseObjects);
            }
            out.writeString(this.tokenizer.getClass().getCanonicalName());
            out.writeParcelable((Parcelable)this.tokenizer, 0);
        }

        public String toString() {
            String str = "TokenCompleteTextView.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " tokens=" + this.baseObjects;
            return str + "}";
        }
    }

    private class TokenTextWatcher
    implements TextWatcher {
        ArrayList<TokenImageSpan> spansToRemove = new ArrayList();

        private TokenTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (count > 0 && TokenCompleteTextView.this.getText() != null) {
                Editable text = TokenCompleteTextView.this.getText();
                int end = start + count;
                TokenImageSpan[] spans = (TokenImageSpan[])text.getSpans(start, end, TokenImageSpan.class);
                ArrayList<TokenImageSpan> spansToRemove = new ArrayList<TokenImageSpan>();
                for (TokenImageSpan token : spans) {
                    if (text.getSpanStart((Object)token) >= end || start >= text.getSpanEnd((Object)token)) continue;
                    spansToRemove.add(token);
                }
                this.spansToRemove = spansToRemove;
            }
        }

        public void afterTextChanged(Editable text) {
            ArrayList<TokenImageSpan> spansCopy = new ArrayList<TokenImageSpan>(this.spansToRemove);
            this.spansToRemove.clear();
            for (TokenImageSpan token : spansCopy) {
                if (text.getSpanStart((Object)token) == -1 || text.getSpanEnd((Object)token) == -1) continue;
                TokenCompleteTextView.this.removeSpan(text, token);
            }
            TokenCompleteTextView.this.clearSelections();
            TokenCompleteTextView.this.updateHint();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    }

    private class TokenSpanWatcher
    implements SpanWatcher {
        private TokenSpanWatcher() {
        }

        public void onSpanAdded(Spannable text, Object what, int start, int end) {
            if (what instanceof TokenImageSpan && !TokenCompleteTextView.this.savingState) {
                TokenImageSpan token = (TokenImageSpan)((Object)what);
                if (!TokenCompleteTextView.this.isFocused() && TokenCompleteTextView.this.allowCollapse) {
                    TokenCompleteTextView.this.performCollapse(false);
                }
                if (TokenCompleteTextView.this.listener != null) {
                    TokenCompleteTextView.this.listener.onTokenAdded(token.getToken());
                }
            }
        }

        public void onSpanRemoved(Spannable text, Object what, int start, int end) {
            if (what instanceof TokenImageSpan && !TokenCompleteTextView.this.savingState) {
                TokenImageSpan token = (TokenImageSpan)((Object)what);
                if (TokenCompleteTextView.this.listener != null) {
                    TokenCompleteTextView.this.listener.onTokenRemoved(token.getToken());
                }
            }
        }

        public void onSpanChanged(Spannable text, Object what, int oldStart, int oldEnd, int newStart, int newEnd) {
        }
    }

    public static interface TokenListener<T> {
        public void onTokenAdded(T var1);

        public void onTokenRemoved(T var1);

        public void onTokenIgnored(T var1);
    }

    protected class TokenImageSpan
    extends ViewSpan
    implements NoCopySpan {
        private T token;

        public TokenImageSpan(View d, T token) {
            super(d, TokenCompleteTextView.this);
            this.token = token;
        }

        public T getToken() {
            return this.token;
        }

        public void onClick() {
            Editable text = TokenCompleteTextView.this.getText();
            if (text == null) {
                return;
            }
            switch (TokenCompleteTextView.this.tokenClickStyle) {
                case Select: 
                case SelectDeselect: {
                    if (!this.view.isSelected()) {
                        TokenCompleteTextView.this.clearSelections();
                        this.view.setSelected(true);
                        break;
                    }
                    if (TokenCompleteTextView.this.tokenClickStyle == TokenClickStyle.SelectDeselect || !TokenCompleteTextView.this.isTokenRemovable(this.token)) {
                        this.view.setSelected(false);
                        TokenCompleteTextView.this.invalidate();
                        break;
                    }
                }
                case Delete: {
                    if (!TokenCompleteTextView.this.isTokenRemovable(this.token)) break;
                    TokenCompleteTextView.this.removeSpan(text, this);
                    break;
                }
                default: {
                    if (TokenCompleteTextView.this.getSelectionStart() == text.getSpanEnd((Object)this)) break;
                    TokenCompleteTextView.this.setSelection(text.getSpanEnd((Object)this));
                }
            }
        }
    }

    public static enum TokenClickStyle {
        None(false),
        Delete(false),
        Select(true),
        SelectDeselect(true);

        private boolean mIsSelectable;

        private TokenClickStyle(boolean selectable) {
            this.mIsSelectable = selectable;
        }

        public boolean isSelectable() {
            return this.mIsSelectable;
        }
    }
}

