/*
 * Decompiled with CFR 0.152.
 */
package spark.webserver;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.SparkServer;
import spark.ssl.SslStores;
import spark.staticfiles.StaticFiles;
import spark.webserver.jetty.JettyServerFactory;
import spark.webserver.jetty.SocketConnectorFactory;
import spark.webserver.websocket.WebSocketServletContextHandlerFactory;

public class JettySparkServer
implements SparkServer {
    private static final int SPARK_DEFAULT_PORT = 4567;
    private static final String NAME = "Spark";
    private Handler handler;
    private Server server;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public JettySparkServer(Handler handler) {
        this.handler = handler;
        System.setProperty("org.mortbay.log.class", "spark.JettyLogger");
    }

    @Override
    public void ignite(String host, int port, SslStores sslStores, String staticFilesFolder, String externalFilesFolder, CountDownLatch latch, int maxThreads, int minThreads, int threadIdleTimeoutMillis, Map<String, Class<?>> webSocketHandlers, Optional<Integer> webSocketIdleTimeoutMillis) {
        if (port == 0) {
            try (ServerSocket s = new ServerSocket(0);){
                port = s.getLocalPort();
            }
            catch (IOException e) {
                this.logger.error("Could not get first available port (port set to 0), using default: {}", (Object)4567);
                port = 4567;
            }
        }
        this.server = JettyServerFactory.createServer(maxThreads, minThreads, threadIdleTimeoutMillis);
        ServerConnector connector = sslStores == null ? SocketConnectorFactory.createSocketConnector(this.server, host, port) : SocketConnectorFactory.createSecureSocketConnector(this.server, host, port, sslStores);
        this.server = connector.getServer();
        this.server.setConnectors(new Connector[]{connector});
        ServletContextHandler webSocketServletContextHandler = WebSocketServletContextHandlerFactory.create(webSocketHandlers, webSocketIdleTimeoutMillis);
        if (staticFilesFolder == null && externalFilesFolder == null && webSocketServletContextHandler == null) {
            this.server.setHandler(this.handler);
        } else {
            ArrayList<Handler> handlersInList = new ArrayList<Handler>();
            handlersInList.add(this.handler);
            StaticFiles.setLocationIfPresent(staticFilesFolder, handlersInList);
            StaticFiles.setExternalLocationIfPresent(externalFilesFolder, handlersInList);
            if (webSocketServletContextHandler != null) {
                handlersInList.add(webSocketServletContextHandler);
            }
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(handlersInList.toArray(new Handler[handlersInList.size()]));
            this.server.setHandler(handlers);
        }
        try {
            this.logger.info("== {} has ignited ...", (Object)NAME);
            this.logger.info(">> Listening on {}:{}", (Object)host, (Object)port);
            this.server.start();
            latch.countDown();
            this.server.join();
        }
        catch (Exception e) {
            this.logger.error("ignite failed", e);
            System.exit(100);
        }
    }

    @Override
    public void stop() {
        this.logger.info(">>> {} shutting down ...", (Object)NAME);
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            this.logger.error("stop failed", e);
            System.exit(100);
        }
        this.logger.info("done");
    }
}

