/*
 * Decompiled with CFR 0.152.
 */
package spark.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.globalstate.ServletFlag;
import spark.resource.AbstractFileResolvingResource;
import spark.resource.AbstractResourceHandler;
import spark.route.RouteMatcherFactory;
import spark.servlet.FilterTools;
import spark.servlet.SparkApplication;
import spark.staticfiles.ServletStaticFiles;
import spark.utils.IOUtils;
import spark.webserver.MatcherFilter;

public class SparkFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SparkFilter.class);
    public static final String APPLICATION_CLASS_PARAM = "applicationClass";
    private String filterPath;
    private MatcherFilter matcherFilter;
    private SparkApplication application;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        ServletFlag.runFromServlet();
        this.application = this.getApplication(filterConfig);
        this.application.init();
        this.filterPath = FilterTools.getFilterPath(filterConfig);
        this.matcherFilter = new MatcherFilter(RouteMatcherFactory.get(), true, false);
    }

    protected SparkApplication getApplication(FilterConfig filterConfig) throws ServletException {
        try {
            String applicationClassName = filterConfig.getInitParameter(APPLICATION_CLASS_PARAM);
            Class<?> applicationClass = Class.forName(applicationClassName);
            return (SparkApplication)applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        final String relativePath = FilterTools.getRelativePath(httpRequest, this.filterPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug(relativePath);
        }
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(httpRequest){

            @Override
            public String getPathInfo() {
                return relativePath;
            }

            @Override
            public String getRequestURI() {
                return relativePath;
            }
        };
        if (ServletStaticFiles.staticResourceHandlers() != null) {
            for (AbstractResourceHandler staticResourceHandler : ServletStaticFiles.staticResourceHandlers()) {
                AbstractFileResolvingResource resource = staticResourceHandler.getResource(httpRequest);
                if (resource == null || !resource.isReadable()) continue;
                IOUtils.copy(resource.getInputStream(), response.getOutputStream());
                return;
            }
        }
        this.matcherFilter.doFilter(requestWrapper, response, chain);
    }

    @Override
    public void destroy() {
        if (this.application != null) {
            this.application.destroy();
        }
    }
}

