/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger LOG = LoggerFactory.getLogger(Response.class);
    private HttpServletResponse response;
    private String body;

    protected Response() {
    }

    Response(HttpServletResponse response) {
        this.response = response;
    }

    public void status(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void type(String contentType) {
        this.response.setContentType(contentType);
    }

    public void body(String body) {
        this.body = body;
    }

    public String body() {
        return this.body;
    }

    public HttpServletResponse raw() {
        return this.response;
    }

    public void redirect(String location) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting ({} {} to {}", "Found", 302, location);
        }
        try {
            this.response.sendRedirect(location);
        }
        catch (IOException ioException) {
            LOG.warn("Redirect failure", ioException);
        }
    }

    public void redirect(String location, int httpStatusCode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting ({} to {}", (Object)httpStatusCode, (Object)location);
        }
        this.response.setStatus(httpStatusCode);
        this.response.setHeader("Location", location);
        this.response.setHeader("Connection", "close");
        try {
            this.response.sendError(httpStatusCode);
        }
        catch (IOException e) {
            LOG.warn("Exception when trying to redirect permanently", e);
        }
    }

    public void header(String header, String value) {
        this.response.addHeader(header, value);
    }

    public void cookie(String name, String value) {
        this.cookie(name, value, -1, false);
    }

    public void cookie(String name, String value, int maxAge) {
        this.cookie(name, value, maxAge, false);
    }

    public void cookie(String name, String value, int maxAge, boolean secured) {
        this.cookie("", name, value, maxAge, secured);
    }

    public void cookie(String path, String name, String value, int maxAge, boolean secured) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secured);
        this.response.addCookie(cookie);
    }

    public void removeCookie(String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
    }
}

