/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ExceptionHandler;
import spark.ExceptionHandlerImpl;
import spark.ExceptionMapper;
import spark.Experimental;
import spark.FilterImpl;
import spark.HaltException;
import spark.Redirect;
import spark.Request;
import spark.Response;
import spark.Routable;
import spark.RouteImpl;
import spark.embeddedserver.EmbeddedServer;
import spark.embeddedserver.EmbeddedServers;
import spark.globalstate.ServletFlag;
import spark.route.Routes;
import spark.route.ServletRoutes;
import spark.ssl.SslStores;
import spark.staticfiles.StaticFilesConfiguration;

public final class Service
extends Routable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spark.Spark");
    public static final int SPARK_DEFAULT_PORT = 4567;
    protected static final String DEFAULT_ACCEPT_TYPE = "*/*";
    protected boolean initialized = false;
    protected int port = 4567;
    protected String ipAddress = "0.0.0.0";
    protected SslStores sslStores;
    protected String staticFileFolder = null;
    protected String externalStaticFileFolder = null;
    protected Map<String, Class<?>> webSocketHandlers = null;
    protected int maxThreads = -1;
    protected int minThreads = -1;
    protected int threadIdleTimeoutMillis = -1;
    protected Optional<Integer> webSocketIdleTimeoutMillis = Optional.empty();
    protected EmbeddedServer server;
    protected Routes routes;
    private boolean servletStaticLocationSet;
    private boolean servletExternalStaticLocationSet;
    private CountDownLatch latch = new CountDownLatch(1);
    private Object embeddedServerIdentifier = null;
    public final Redirect redirect = Redirect.create(this);
    public final StaticFiles staticFiles = new StaticFiles();
    private final StaticFilesConfiguration staticFilesConfiguration = ServletFlag.isRunningFromServlet() ? StaticFilesConfiguration.servletInstance : StaticFilesConfiguration.create();

    public static Service ignite() {
        return new Service();
    }

    private Service() {
    }

    public synchronized Service ipAddress(String ipAddress) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.ipAddress = ipAddress;
        return this;
    }

    public synchronized Service port(int port) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.port = port;
        return this;
    }

    public synchronized Service secure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (keystoreFile == null) {
            throw new IllegalArgumentException("Must provide a keystore file to run secured");
        }
        this.sslStores = SslStores.create(keystoreFile, keystorePassword, truststoreFile, truststorePassword);
        return this;
    }

    public synchronized Service threadPool(int maxThreads) {
        return this.threadPool(maxThreads, -1, -1);
    }

    public synchronized Service threadPool(int maxThreads, int minThreads, int idleTimeoutMillis) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        this.maxThreads = maxThreads;
        this.minThreads = minThreads;
        this.threadIdleTimeoutMillis = idleTimeoutMillis;
        return this;
    }

    public synchronized Service staticFileLocation(String folder) {
        if (this.initialized && !ServletFlag.isRunningFromServlet()) {
            this.throwBeforeRouteMappingException();
        }
        this.staticFileFolder = folder;
        if (!this.servletStaticLocationSet) {
            this.staticFilesConfiguration.configure(this.staticFileFolder);
            this.servletStaticLocationSet = true;
        } else {
            LOG.warn("Static file location has already been set");
        }
        return this;
    }

    public synchronized Service externalStaticFileLocation(String externalFolder) {
        if (this.initialized && !ServletFlag.isRunningFromServlet()) {
            this.throwBeforeRouteMappingException();
        }
        this.externalStaticFileFolder = externalFolder;
        if (!this.servletExternalStaticLocationSet) {
            this.staticFilesConfiguration.configureExternal(this.externalStaticFileFolder);
            this.servletExternalStaticLocationSet = true;
        } else {
            LOG.warn("External static file location has already been set");
        }
        return this;
    }

    public synchronized void webSocket(String path, Class<?> handler) {
        Objects.requireNonNull(path, "WebSocket path cannot be null");
        Objects.requireNonNull(handler, "WebSocket handler class cannot be null");
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (ServletFlag.isRunningFromServlet()) {
            throw new IllegalStateException("WebSockets are only supported in the embedded server");
        }
        if (this.webSocketHandlers == null) {
            this.webSocketHandlers = new HashMap();
        }
        this.webSocketHandlers.put(path, handler);
    }

    public synchronized Service webSocketIdleTimeoutMillis(int timeoutMillis) {
        if (this.initialized) {
            this.throwBeforeRouteMappingException();
        }
        if (ServletFlag.isRunningFromServlet()) {
            throw new IllegalStateException("WebSockets are only supported in the embedded server");
        }
        this.webSocketIdleTimeoutMillis = Optional.of(timeoutMillis);
        return this;
    }

    public void awaitInitialization() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted by another thread");
        }
    }

    private void throwBeforeRouteMappingException() {
        throw new IllegalStateException("This must be done before route mapping has begun");
    }

    private boolean hasMultipleHandlers() {
        return this.webSocketHandlers != null;
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.routes.clear();
            this.server.extinguish();
            this.latch = new CountDownLatch(1);
        }
        this.staticFilesConfiguration.clear();
        this.initialized = false;
    }

    @Override
    public void addRoute(String httpMethod, RouteImpl route) {
        this.init();
        this.routes.add(httpMethod + " '" + route.getPath() + "'", route.getAcceptType(), route);
    }

    @Override
    public void addFilter(String httpMethod, FilterImpl filter) {
        this.init();
        this.routes.add(httpMethod + " '" + filter.getPath() + "'", filter.getAcceptType(), filter);
    }

    public synchronized void init() {
        if (!this.initialized) {
            this.initializeRouteMatcher();
            if (!ServletFlag.isRunningFromServlet()) {
                new Thread(() -> {
                    EmbeddedServers.initialize();
                    if (this.embeddedServerIdentifier == null) {
                        this.embeddedServerIdentifier = EmbeddedServers.defaultIdentifier();
                    }
                    this.server = EmbeddedServers.create(this.embeddedServerIdentifier, this.routes, this.staticFilesConfiguration, this.hasMultipleHandlers());
                    this.server.configureWebSockets(this.webSocketHandlers, this.webSocketIdleTimeoutMillis);
                    this.server.ignite(this.ipAddress, this.port, this.sslStores, this.latch, this.maxThreads, this.minThreads, this.threadIdleTimeoutMillis);
                }).start();
            }
            this.initialized = true;
        }
    }

    private void initializeRouteMatcher() {
        this.routes = ServletFlag.isRunningFromServlet() ? ServletRoutes.get() : Routes.create();
    }

    public synchronized void exception(Class<? extends Exception> exceptionClass, final ExceptionHandler handler) {
        ExceptionHandlerImpl wrapper = new ExceptionHandlerImpl(exceptionClass){

            @Override
            public void handle(Exception exception, Request request, Response response) {
                handler.handle(exception, request, response);
            }
        };
        ExceptionMapper.getInstance().map(exceptionClass, wrapper);
    }

    public void halt() {
        throw new HaltException();
    }

    public void halt(int status) {
        throw new HaltException(status);
    }

    public void halt(String body) {
        throw new HaltException(body);
    }

    public void halt(int status, String body) {
        throw new HaltException(status, body);
    }

    public final class StaticFiles {
        public void location(String folder) {
            Service.this.staticFileLocation(folder);
        }

        public void externalLocation(String externalFolder) {
            Service.this.externalStaticFileLocation(externalFolder);
        }

        public void headers(Map<String, String> headers) {
            Service.this.staticFilesConfiguration.putCustomHeaders(headers);
        }

        public void header(String key, String value) {
            Service.this.staticFilesConfiguration.putCustomHeader(key, value);
        }

        @Experimental(value="Functionality will not be removed. The API might change")
        public void expireTime(long seconds) {
            Service.this.staticFilesConfiguration.setExpireTimeSeconds(seconds);
        }
    }
}

