/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.Cipher;
import com.soywiz.krypto.CipherModeIVDE;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lcom/soywiz/krypto/CipherModeCTR;", "Lcom/soywiz/krypto/CipherModeIVDE;", "()V", "coreCrypt", "", "pData", "", "cipher", "Lcom/soywiz/krypto/Cipher;", "ivb", "krypto"})
final class CipherModeCTR
extends CipherModeIVDE {
    @NotNull
    public static final CipherModeCTR INSTANCE = new CipherModeCTR();

    private CipherModeCTR() {
        super("CTR");
    }

    @Override
    protected void coreCrypt(@NotNull byte[] pData, @NotNull Cipher cipher, @NotNull byte[] ivb) {
        int blockSize = cipher.getBlockSize();
        byte[] temp = new byte[ivb.length];
        int n = pData.length + -1;
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + blockSize + '.');
        }
        int n2 = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)blockSize);
        if (n2 <= n3) {
            while (true) {
                KryptoToolsKt.arraycopy(ivb, 0, temp, 0, temp.length);
                cipher.encrypt(temp, 0, blockSize);
                KryptoToolsKt.arrayxor(pData, n2, temp);
                for (int j = blockSize - 1; -1 < j; --j) {
                    int n4 = j;
                    byte by = ivb[n4];
                    ivb[n4] = (byte)(by + 1);
                    if (ivb[j] != 0) break;
                }
                if (n2 == n3) break;
                n2 += blockSize;
            }
        }
    }
}

