/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.Hash;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H$J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH$J\b\u0010\u0012\u001a\u00020\u000fH$J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0007J \u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/soywiz/krypto/Hasher;", "", "chunkSize", "", "digestSize", "(II)V", "chunk", "", "getChunkSize", "()I", "getDigestSize", "totalWritten", "", "writtenInChunk", "coreDigest", "", "out", "corePadding", "coreReset", "coreUpdate", "digest", "Lcom/soywiz/krypto/Hash;", "digestOut", "reset", "update", "data", "offset", "count", "krypto"})
public abstract class Hasher {
    private final int chunkSize;
    private final int digestSize;
    @NotNull
    private final byte[] chunk;
    private int writtenInChunk;
    private long totalWritten;

    public Hasher(int chunkSize, int digestSize) {
        this.chunkSize = chunkSize;
        this.digestSize = digestSize;
        this.chunk = new byte[this.chunkSize];
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final int getDigestSize() {
        return this.digestSize;
    }

    @NotNull
    public final Hasher reset() {
        this.coreReset();
        this.writtenInChunk = 0;
        this.totalWritten = 0L;
        return this;
    }

    @NotNull
    public Hasher update(@NotNull byte[] data, int offset, int count) {
        int curr = offset;
        int left = count;
        while (left > 0) {
            int remainingInChunk = this.chunkSize - this.writtenInChunk;
            int toRead = Math.min(remainingInChunk, left);
            KryptoToolsKt.arraycopy(data, curr, this.chunk, this.writtenInChunk, toRead);
            left -= toRead;
            curr += toRead;
            this.writtenInChunk += toRead;
            if (this.writtenInChunk < this.chunkSize) continue;
            this.writtenInChunk -= this.chunkSize;
            this.coreUpdate(this.chunk);
        }
        this.totalWritten += (long)count;
        return this;
    }

    public void digestOut(@NotNull byte[] out) {
        int padSize;
        byte[] pad = this.corePadding(this.totalWritten);
        for (int padPos = 0; padPos < pad.length; padPos += padSize) {
            padSize = this.chunkSize - this.writtenInChunk;
            KryptoToolsKt.arraycopy(pad, padPos, this.chunk, this.writtenInChunk, padSize);
            this.coreUpdate(this.chunk);
            this.writtenInChunk = 0;
        }
        this.coreDigest(out);
        this.coreReset();
    }

    protected abstract void coreReset();

    @NotNull
    protected abstract byte[] corePadding(long var1);

    protected abstract void coreUpdate(@NotNull byte[] var1);

    protected abstract void coreDigest(@NotNull byte[] var1);

    @NotNull
    public final Hasher update(@NotNull byte[] data) {
        return this.update(data, 0, data.length);
    }

    @NotNull
    public final Hash digest() {
        byte[] byArray;
        byte[] it = byArray = new byte[this.digestSize];
        boolean bl = false;
        this.digestOut(it);
        byte[] byArray2 = byArray;
        return new Hash(byArray2);
    }
}

