/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.MultilineBuildLogIndication;
import hudson.model.Run;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultilineBuildLogFailureReader
extends FailureReader {
    private static final Logger logger = Logger.getLogger(MultilineBuildLogFailureReader.class.getName());

    public MultilineBuildLogFailureReader(MultilineBuildLogIndication indication) {
        super(indication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FoundIndication scan(Run build) throws IOException {
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(build.getLogReader());
            FoundIndication foundIndication = this.scanMultiLineOneFile(build, reader, "log");
            return foundIndication;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public FoundIndication scan(Run build, PrintStream buildLog) {
        FoundIndication foundIndication;
        block22: {
            long start;
            LineNumberReader reader;
            block19: {
                foundIndication = null;
                reader = null;
                start = System.currentTimeMillis();
                reader = new LineNumberReader(build.getLogReader());
                foundIndication = this.scanMultiLineOneFile(build, reader, "log");
                if (reader == null) break block19;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the reader. ", e);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
            }
            break block22;
            catch (IOException ioe) {
                block20: {
                    logger.log(Level.SEVERE, "[BFA] I/O problems during indication analysis: ", ioe);
                    buildLog.println("[BFA] I/O problems during indication analysis.");
                    if (reader == null) break block20;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to close the reader. ", e);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
                }
            }
            catch (Exception e) {
                block21: {
                    logger.log(Level.SEVERE, "[BFA] Could not open reader for indication: ", e);
                    buildLog.println("[BFA] Could not open reader for indication.");
                    if (reader == null) break block21;
                    {
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e2) {
                                    logger.log(Level.WARNING, "Failed to close the reader. ", e2);
                                }
                            }
                            if (logger.isLoggable(Level.FINER)) {
                                logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
                            }
                            throw throwable;
                        }
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        logger.log(Level.WARNING, "Failed to close the reader. ", e3);
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[BFA] [{0}] - [{1}] {2}ms", new Object[]{build.getFullDisplayName(), this.indication.toString(), String.valueOf(System.currentTimeMillis() - start)});
                }
            }
        }
        return foundIndication;
    }
}

