/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.sod;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ScanOnDemandVariables
extends AbstractDescribableImpl<ScanOnDemandVariables> {
    public static final int DEFAULT_MINIMUM_SOD_WORKER_THREADS = 1;
    public static final int DEFAULT_MAXIMUM_SOD_WORKER_THREADS = 1;
    public static final int DEFAULT_SOD_THREADS_KEEP_ALIVE_TIME = 15;
    public static final int DEFAULT_SOD_WAIT_FOR_JOBS_SHUTDOWN_TIMEOUT = 30;
    public static final int DEFAULT_SOD_COREPOOL_THREADS = 5;
    private int minimumSodWorkerThreads;
    private int maximumSodWorkerThreads;
    private int sodThreadKeepAliveTime;
    private int sodWaitForJobShutdownTimeout;
    private int sodCorePoolNumberOfThreads;

    @DataBoundConstructor
    public ScanOnDemandVariables() {
    }

    @DataBoundSetter
    public void setMaximumSodWorkerThreads(int maximumSodWorkerThreads) {
        this.maximumSodWorkerThreads = maximumSodWorkerThreads;
    }

    @DataBoundSetter
    public void setMinimumSodWorkerThreads(int minimumSodWorkerThreads) {
        this.minimumSodWorkerThreads = minimumSodWorkerThreads;
    }

    @DataBoundSetter
    public void setSodCorePoolNumberOfThreads(int sodCorePoolNumberOfThreads) {
        this.sodCorePoolNumberOfThreads = sodCorePoolNumberOfThreads;
    }

    @DataBoundSetter
    public void setSodThreadKeepAliveTime(int sodThreadKeepAliveTime) {
        this.sodThreadKeepAliveTime = sodThreadKeepAliveTime;
    }

    @DataBoundSetter
    public void setSodWaitForJobShutdownTimeout(int sodWaitForJobShutdownTimeout) {
        this.sodWaitForJobShutdownTimeout = sodWaitForJobShutdownTimeout;
    }

    public int getSodCorePoolNumberOfThreads() {
        if (this.sodCorePoolNumberOfThreads < 5) {
            return 5;
        }
        return this.sodCorePoolNumberOfThreads;
    }

    public int getMaximumSodWorkerThreads() {
        if (this.maximumSodWorkerThreads < 1) {
            return 1;
        }
        return this.maximumSodWorkerThreads;
    }

    public int getMinimumSodWorkerThreads() {
        if (this.minimumSodWorkerThreads < 1) {
            return 1;
        }
        return this.minimumSodWorkerThreads;
    }

    public int getSodThreadKeepAliveTime() {
        if (this.sodThreadKeepAliveTime < 15) {
            return 15;
        }
        return this.sodThreadKeepAliveTime;
    }

    public int getSodWaitForJobShutdownTimeout() {
        if (this.sodWaitForJobShutdownTimeout < 30) {
            return 30;
        }
        return this.sodWaitForJobShutdownTimeout;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ScanOnDemandVariables> {
    }
}

