/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.statistics;

import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Statistics {
    private String projectName;
    private int buildNumber;
    private Date startingTime;
    private long duration;
    private List<String> triggerCauses;
    private String slave;
    private String master;
    private int timeZoneOffset;
    private String result;
    private List<FailureCauseStatistics> failureCauseStatisticsList;

    public String getProjectName() {
        return this.projectName;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public Date getStartingTime() {
        if (this.startingTime == null) {
            return null;
        }
        return new Date(this.startingTime.getTime());
    }

    public long getDuration() {
        return this.duration;
    }

    public List<String> getTriggerCauses() {
        return this.triggerCauses;
    }

    public String getSlaveHostName() {
        return this.slave;
    }

    public String getMaster() {
        return this.master;
    }

    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public String getResult() {
        return this.result;
    }

    public List<FailureCauseStatistics> getFailureCauseStatisticsList() {
        return this.failureCauseStatisticsList;
    }

    @JsonCreator
    public Statistics(@JsonProperty(value="projectName") String projectName, @JsonProperty(value="buildNumber") int buildNumber, @JsonProperty(value="startingTime") Date startingTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="triggerCauses") List<String> triggerCauses, @JsonProperty(value="slaveHostName") String nodeName, @JsonProperty(value="master") String master, @JsonProperty(value="timeZoneOffset") int timeZoneOffset, @JsonProperty(value="result") String result, @JsonProperty(value="failureCauses") List<FailureCauseStatistics> failureCauseStatistics) {
        this.projectName = projectName;
        this.buildNumber = buildNumber;
        this.startingTime = startingTime == null ? null : new Date(startingTime.getTime());
        this.duration = duration;
        this.triggerCauses = triggerCauses;
        this.slave = nodeName;
        this.master = master;
        this.timeZoneOffset = timeZoneOffset;
        this.result = result;
        this.failureCauseStatisticsList = failureCauseStatistics;
    }
}

