/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.graphs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.util.Graph;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GraphCache {
    private static final int EXPIRATION_TIME_MINUTES = 30;
    private static GraphCache instance;
    private Cache<String, Graph> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();

    private GraphCache() {
    }

    public static synchronized GraphCache getInstance() {
        if (instance == null) {
            instance = new GraphCache();
        }
        return instance;
    }

    public void invalidate(String key) {
        this.cache.invalidate((Object)key);
    }

    public void invalidateMatching(Pattern pattern) {
        for (String key : this.getMatchingCacheKeys(pattern)) {
            this.invalidate(key);
        }
    }

    public List<String> getMatchingCacheKeys(Pattern pattern) {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.cache != null) {
            Set keySet = this.cache.asMap().keySet();
            for (String key : keySet) {
                Matcher keyMatcher = pattern.matcher(key);
                if (!keyMatcher.matches()) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public static int getExpirationTime() {
        return 30;
    }

    public Graph get(String key, Callable<Graph> callable) throws ExecutionException {
        return (Graph)this.cache.get((Object)key, callable);
    }
}

