/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.LocalFileKnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.ScannerJobProperty;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class PluginImpl
extends Plugin {
    private static final Logger logger = Logger.getLogger(PluginImpl.class.getName());
    public static final String DEFAULT_ICON_SIZE = "24x24";
    public static final String DEFAULT_ICON_NAME = "information.png";
    public static final int DEFAULT_NR_OF_SCAN_THREADS = 3;
    public static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(PluginImpl.class, Messages._PermissionGroup_Title());
    public static final Permission UPDATE_PERMISSION = new Permission(PERMISSION_GROUP, "UpdateCauses", Messages._PermissionUpdate_Description(), Hudson.ADMINISTER);
    public static final Permission REMOVE_PERMISSION = new Permission(PERMISSION_GROUP, "RemoveCause", Messages._PermissionRemove_Description(), Hudson.ADMINISTER);
    private static final String DEFAULT_NO_CAUSES_MESSAGE = "No problems were identified. If you know why this problem occurred, please add a suitable Cause for it.";
    private static String staticResourcesBase = null;
    protected static final int MINIMUM_NR_OF_SCAN_THREADS = 1;
    private String noCausesMessage;
    private Boolean globalEnabled;
    private Boolean gerritTriggerEnabled;
    private transient CopyOnWriteList<FailureCause> causes;
    private KnowledgeBase knowledgeBase;
    private int nrOfScanThreads;

    public void start() throws Exception {
        super.start();
        logger.finer("[BFA] Starting...");
        this.load();
        if (this.noCausesMessage == null) {
            this.noCausesMessage = DEFAULT_NO_CAUSES_MESSAGE;
        }
        if (this.nrOfScanThreads < 1) {
            this.nrOfScanThreads = 3;
        }
        if (this.knowledgeBase == null) {
            if (this.causes == null) {
                this.knowledgeBase = new LocalFileKnowledgeBase();
            } else {
                this.knowledgeBase = new LocalFileKnowledgeBase(this.causes);
                this.causes = null;
            }
        }
        try {
            this.knowledgeBase.start();
            logger.fine("[BFA] Started!");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not initialize the knowledge base: ", e);
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.knowledgeBase.stop();
    }

    public static String getStaticResourcesBase() {
        if (staticResourcesBase == null) {
            PluginWrapper wrapper;
            PluginManager pluginManager = Hudson.getInstance().getPluginManager();
            if (pluginManager != null && (wrapper = pluginManager.getPlugin(PluginImpl.class)) != null) {
                staticResourcesBase = "/plugin/" + wrapper.getShortName();
            }
            if (staticResourcesBase == null) {
                return "/plugin/build-failure-analyzer";
            }
        }
        return staticResourcesBase;
    }

    public static String getStaticImagesBase() {
        return PluginImpl.getStaticResourcesBase() + "/images";
    }

    public static String getImageUrl(String size, String name) {
        return PluginImpl.getStaticImagesBase() + "/" + size + "/" + name;
    }

    public static String getFullImageUrl(String size, String name) {
        return Hudson.getInstance().getRootUrlFromRequest() + PluginImpl.getStaticImagesBase() + "/" + size + "/" + name;
    }

    public static String getImageUrl(String name) {
        return PluginImpl.getImageUrl(DEFAULT_ICON_SIZE, name);
    }

    public static String getDefaultIcon() {
        return PluginImpl.getImageUrl(DEFAULT_ICON_NAME);
    }

    public static PluginImpl getInstance() {
        return (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
    }

    public String getNoCausesMessage() {
        return this.noCausesMessage;
    }

    public boolean isGlobalEnabled() {
        if (this.globalEnabled == null) {
            return true;
        }
        return this.globalEnabled;
    }

    public void setGlobalEnabled(Boolean globalEnabled) {
        this.globalEnabled = globalEnabled;
    }

    public boolean isGerritTriggerEnabled() {
        if (this.gerritTriggerEnabled == null) {
            return true;
        }
        return this.gerritTriggerEnabled;
    }

    public void setGerritTriggerEnabled(Boolean gerritTriggerEnabled) {
        this.gerritTriggerEnabled = gerritTriggerEnabled;
    }

    public int getNrOfScanThreads() {
        if (this.nrOfScanThreads < 1) {
            this.nrOfScanThreads = 3;
        }
        return this.nrOfScanThreads;
    }

    public void setNrOfScanThreads(int nrOfScanThreads) {
        if (nrOfScanThreads < 1) {
            throw new IllegalArgumentException("Minimum nrOfScanThreads is 1");
        }
        this.nrOfScanThreads = nrOfScanThreads;
    }

    public static boolean shouldScan(AbstractBuild build) {
        if (PluginImpl.getInstance().isGlobalEnabled()) {
            AbstractProject project = build.getProject();
            ScannerJobProperty property = (ScannerJobProperty)project.getProperty(ScannerJobProperty.class);
            if (property != null) {
                return !property.isDoNotScan();
            }
            return true;
        }
        return false;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public ExtensionList<KnowledgeBase.KnowledgeBaseDescriptor> getKnowledgeBaseDescriptors() {
        return KnowledgeBase.KnowledgeBaseDescriptor.all();
    }

    public KnowledgeBase.KnowledgeBaseDescriptor getKnowledgeBaseDescriptor(String descString) {
        for (KnowledgeBase.KnowledgeBaseDescriptor desc : this.getKnowledgeBaseDescriptors()) {
            if (!((Object)((Object)desc)).getClass().toString().contains(descString)) continue;
            return desc;
        }
        return null;
    }

    public void configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException, IOException {
        this.noCausesMessage = o.getString("noCausesMessage");
        this.globalEnabled = o.getBoolean("globalEnabled");
        this.gerritTriggerEnabled = o.getBoolean("gerritTriggerEnabled");
        int scanThreads = o.getInt("nrOfScanThreads");
        this.nrOfScanThreads = scanThreads < 1 ? 3 : scanThreads;
        KnowledgeBase base = (KnowledgeBase)req.bindJSON(KnowledgeBase.class, o.getJSONObject("knowledgeBase"));
        if (base != null && !this.knowledgeBase.equals(base)) {
            try {
                base.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not start new knowledge base, reverting ", e);
                this.save();
                return;
            }
            if (o.getBoolean("convertOldKb")) {
                try {
                    base.convertFrom(this.knowledgeBase);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not convert knowledge base ", e);
                }
            }
            this.knowledgeBase.stop();
            this.knowledgeBase = base;
        }
        this.save();
    }
}

