/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FailureCauseBuildAction
implements BuildBadgeAction {
    private transient List<FailureCause> failureCauses;
    private List<FoundFailureCause> foundFailureCauses;
    public static final String URL_NAME = "bfa";
    private static final Logger logger = Logger.getLogger(FailureCauseBuildAction.class.getName());

    public FailureCauseBuildAction(List<FoundFailureCause> foundFailureCauses) {
        this.foundFailureCauses = foundFailureCauses;
    }

    public String getIconFileName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION)) {
            return PluginImpl.getDefaultIcon();
        }
        return null;
    }

    public String getDisplayName() {
        if (Hudson.getInstance().hasPermission(PluginImpl.UPDATE_PERMISSION)) {
            return Messages.CauseManagement_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public List<FoundFailureCause> getFoundFailureCauses() {
        return this.foundFailureCauses;
    }

    public String getImageUrl() {
        return PluginImpl.getFullImageUrl("48x48", "information.png");
    }

    public String getBadgeImageUrl() {
        return PluginImpl.getFullImageUrl("16x16", "information.png");
    }

    public PluginImpl getPluginImpl() {
        return PluginImpl.getInstance();
    }

    public Object readResolve() {
        if (this.failureCauses != null) {
            LinkedList<FoundFailureCause> list = new LinkedList<FoundFailureCause>();
            for (FailureCause fc : this.failureCauses) {
                list.add(new FoundFailureCause(fc));
            }
            this.foundFailureCauses = list;
            this.failureCauses = null;
        }
        return this;
    }

    public FoundFailureCause getDynamic(String token, StaplerRequest req, StaplerResponse resp) {
        try {
            int causeNumber = Integer.parseInt(token) - 1;
            if (causeNumber >= 0 && causeNumber < this.foundFailureCauses.size()) {
                return this.foundFailureCauses.get(causeNumber);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "[BFA] Failed to parse token for getDynamic: " + token);
            return null;
        }
        logger.log(Level.WARNING, "[BFA] Unable to navigate to the FailureCause: " + token);
        return null;
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) throws IOException {
        resp.sendRedirect2("../../failure-cause-management");
    }
}

