/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.sonyericsson.jenkins.plugins.bfa.db.MongoDBKnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.Semaphore;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mongojack.DBCursor;
import org.mongojack.JacksonDBCollection;

public class MongoDBKnowledgeBaseCache {
    private Semaphore shouldUpdate;
    private UpdateThread updaterThread;
    private Timer timer;
    private TimerTask timerTask;
    private List<FailureCause> cachedFailureCauses;
    private List<String> categories;
    private JacksonDBCollection<FailureCause, String> jacksonCollection;
    private static final long CACHE_UPDATE_INTERVAL = 60000L;
    private static final Logger logger = Logger.getLogger(MongoDBKnowledgeBase.class.getName());

    public MongoDBKnowledgeBaseCache(JacksonDBCollection<FailureCause, String> jacksonCollection) {
        this.jacksonCollection = jacksonCollection;
    }

    public void start() {
        this.shouldUpdate = new Semaphore();
        this.updaterThread = new UpdateThread();
        this.updaterThread.start();
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                MongoDBKnowledgeBaseCache.this.shouldUpdate.release();
            }
        };
        this.timer.scheduleAtFixedRate(this.timerTask, 0L, 60000L);
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
        this.timerTask = null;
        this.updaterThread.stopThread();
        this.updaterThread = null;
    }

    public void updateCache() {
        if (this.shouldUpdate != null) {
            this.shouldUpdate.release();
        }
    }

    public List<FailureCause> getCauses() {
        return this.cachedFailureCauses;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    protected class UpdateThread
    extends Thread {
        private volatile boolean stop = false;

        protected UpdateThread() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    MongoDBKnowledgeBaseCache.this.shouldUpdate.acquire();
                    if (this.stop) break;
                    LinkedList<Object> list = new LinkedList<Object>();
                    DBCursor dbCauses = MongoDBKnowledgeBaseCache.this.jacksonCollection.find((DBObject)MongoDBKnowledgeBase.NOT_REMOVED_QUERY);
                    while (dbCauses.hasNext()) {
                        list.add(dbCauses.next());
                    }
                    MongoDBKnowledgeBaseCache.this.cachedFailureCauses = list;
                    MongoDBKnowledgeBaseCache.this.categories = MongoDBKnowledgeBaseCache.this.jacksonCollection.distinct("categories");
                }
                catch (MongoException e) {
                    logger.log(Level.SEVERE, "MongoException caught when updating cache: ", e);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Updater thread interrupted", e);
                }
            }
        }

        protected void stopThread() {
            this.stop = true;
            MongoDBKnowledgeBaseCache.this.shouldUpdate.release();
        }
    }
}

