/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.tokens;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;

public final class TokenUtils {
    private TokenUtils() {
    }

    static List<String> wrap(String text, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        Splitter lineSplitter = Splitter.on((Pattern)Pattern.compile("\\r?\\n"));
        for (String line : lineSplitter.split((CharSequence)text)) {
            if (width > 0) {
                Pattern firstNonwhitespacePattern = Pattern.compile("[^\\s]");
                Matcher firstNonwhiteSpaceMatcher = firstNonwhitespacePattern.matcher(line);
                String indent = "";
                if (firstNonwhiteSpaceMatcher.find()) {
                    indent = line.substring(0, firstNonwhiteSpaceMatcher.start());
                }
                String wrappedLines = WordUtils.wrap((String)line, (int)(width - indent.length()));
                for (String wrappedLine : lineSplitter.split((CharSequence)wrappedLines)) {
                    lines.add(indent + wrappedLine.trim());
                }
                continue;
            }
            lines.add(line);
        }
        return lines;
    }
}

