/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.MongoDBKnowledgeBaseCache;
import com.sonyericsson.jenkins.plugins.bfa.graphs.FailureCauseTimeInterval;
import com.sonyericsson.jenkins.plugins.bfa.graphs.GraphFilterBuilder;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import com.sonyericsson.jenkins.plugins.bfa.utils.BfaUtils;
import com.sonyericsson.jenkins.plugins.bfa.utils.ObjectCountPair;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.bson.types.ObjectId;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.TimePeriod;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.mongojack.internal.MongoJackModule;

public class MongoDBKnowledgeBase
extends KnowledgeBase {
    private static final long serialVersionUID = 4984133048405390951L;
    public static final String COLLECTION_NAME = "failureCauses";
    public static final String STATISTICS_COLLECTION_NAME = "statistics";
    private static final int MONGO_DEFAULT_PORT = 27017;
    static final BasicDBObject NOT_REMOVED_QUERY = new BasicDBObject("_removed", (Object)new BasicDBObject("$exists", (Object)false));
    private static final Logger logger = Logger.getLogger(MongoDBKnowledgeBase.class.getName());
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SERVER_SELECTION_TIMEOUT = 5000;
    private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance().withClassLoader(MongoDBKnowledgeBase.class.getClassLoader());
    private static final ObjectMapper OBJECT_MAPPER = MongoJackModule.configure((ObjectMapper)new ObjectMapper()).setTypeFactory(TYPE_FACTORY);
    private transient MongoClient mongo;
    private transient DB db;
    private transient DBCollection collection;
    private transient DBCollection statisticsCollection;
    private transient JacksonDBCollection<FailureCause, String> jacksonCollection;
    private transient JacksonDBCollection<Statistics, String> jacksonStatisticsCollection;
    private transient MongoDBKnowledgeBaseCache cache;
    private String host;
    private int port;
    private String dbName;
    private String userName;
    private Secret password;
    private boolean enableStatistics;
    private boolean successfulLogging;

    public String getUserName() {
        return this.userName;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDbName() {
        return this.dbName;
    }

    @DataBoundConstructor
    public MongoDBKnowledgeBase(String host, int port, String dbName, String userName, Secret password, boolean enableStatistics, boolean successfulLogging) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.userName = userName;
        this.password = password;
        this.enableStatistics = enableStatistics;
        this.successfulLogging = successfulLogging;
    }

    @Override
    public synchronized void start() {
        this.initCache();
    }

    @Override
    public synchronized void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    private void initCache() {
        if (this.cache == null) {
            this.cache = new MongoDBKnowledgeBaseCache(this.getJacksonCollection());
            this.cache.start();
        }
    }

    @Override
    public Collection<FailureCause> getCauses() {
        this.initCache();
        return this.cache.getCauses();
    }

    @Override
    public Collection<FailureCause> getCauseNames() {
        LinkedList<FailureCause> list = new LinkedList<FailureCause>();
        BasicDBObject keys = new BasicDBObject();
        keys.put("name", (Object)1);
        org.mongojack.DBCursor dbCauses = this.getJacksonCollection().find((DBObject)NOT_REMOVED_QUERY, (DBObject)keys);
        while (dbCauses.hasNext()) {
            list.add((FailureCause)dbCauses.next());
        }
        return list;
    }

    @Override
    public Collection<FailureCause> getShallowCauses() {
        LinkedList<FailureCause> list = new LinkedList<FailureCause>();
        BasicDBObject keys = new BasicDBObject();
        keys.put("name", (Object)1);
        keys.put("description", (Object)1);
        keys.put("categories", (Object)1);
        keys.put("comment", (Object)1);
        keys.put("modifications", (Object)1);
        keys.put("lastOccurred", (Object)1);
        BasicDBObject orderBy = new BasicDBObject("name", (Object)1);
        org.mongojack.DBCursor dbCauses = this.getJacksonCollection().find((DBObject)NOT_REMOVED_QUERY, (DBObject)keys);
        dbCauses = dbCauses.sort((DBObject)orderBy);
        while (dbCauses.hasNext()) {
            list.add((FailureCause)dbCauses.next());
        }
        return list;
    }

    @Override
    public FailureCause getCause(String id) {
        FailureCause returnCase = null;
        try {
            returnCase = (FailureCause)this.getJacksonCollection().findOneById((Object)id);
        }
        catch (IllegalArgumentException e) {
            logger.fine("Could not find the id, returning null for id: " + id);
            return returnCase;
        }
        return returnCase;
    }

    @Override
    public FailureCause addCause(FailureCause cause) {
        return this.addCause(cause, true);
    }

    @Override
    public FailureCause removeCause(String id) {
        BasicDBObject idq = new BasicDBObject("_id", (Object)new ObjectId(id));
        BasicDBObject removedInfo = new BasicDBObject("timestamp", (Object)new Date());
        removedInfo.put((Object)"by", (Object)Jenkins.getAuthentication().getName());
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("_removed", (Object)removedInfo));
        FailureCause modified = (FailureCause)this.getJacksonCollection().findAndModify((DBObject)idq, null, null, false, (DBObject)update, true, false);
        this.initCache();
        this.cache.updateCache();
        return modified;
    }

    public FailureCause addCause(FailureCause cause, boolean doUpdate) {
        WriteResult result = this.getJacksonCollection().insert((Object)cause);
        if (doUpdate) {
            this.initCache();
            this.cache.updateCache();
        }
        return (FailureCause)result.getSavedObject();
    }

    @Override
    public FailureCause saveCause(FailureCause cause) {
        return this.saveCause(cause, true);
    }

    public FailureCause saveCause(FailureCause cause, boolean doUpdate) {
        WriteResult result = this.getJacksonCollection().save((Object)cause);
        if (doUpdate) {
            this.initCache();
            this.cache.updateCache();
        }
        return (FailureCause)result.getSavedObject();
    }

    @Override
    public void convertFrom(KnowledgeBase oldKnowledgeBase) throws Exception {
        if (oldKnowledgeBase instanceof MongoDBKnowledgeBase) {
            this.convertFromAbstract(oldKnowledgeBase);
            this.convertRemoved((MongoDBKnowledgeBase)oldKnowledgeBase);
        } else {
            for (FailureCause cause : oldKnowledgeBase.getCauseNames()) {
                try {
                    if (this.getCause(cause.getId()) != null) {
                        this.saveCause(cause, false);
                        continue;
                    }
                    cause.setId(null);
                    this.addCause(cause, false);
                }
                catch (MongoException e) {
                    cause.setId(null);
                    this.addCause(cause, false);
                }
            }
            this.initCache();
            this.cache.updateCache();
        }
    }

    @Override
    public List<String> getCategories() {
        this.initCache();
        return this.cache.getCategories();
    }

    protected void convertRemoved(MongoDBKnowledgeBase oldKnowledgeBase) throws Exception {
        List<DBObject> removed = oldKnowledgeBase.getRemovedCauses();
        DBCollection dbCollection = this.getJacksonCollection().getDbCollection();
        for (DBObject obj : removed) {
            dbCollection.save(obj);
        }
    }

    protected List<DBObject> getRemovedCauses() throws Exception {
        BasicDBObject query = new BasicDBObject("_removed", (Object)new BasicDBObject("$exists", (Object)true));
        DBCursor dbCursor = this.getJacksonCollection().getDbCollection().find((DBObject)query);
        LinkedList<DBObject> removed = new LinkedList<DBObject>();
        while (dbCursor.hasNext()) {
            removed.add(dbCursor.next());
        }
        return removed;
    }

    @Override
    public boolean equals(KnowledgeBase oldKnowledgeBase) {
        if (this.getClass().isInstance(oldKnowledgeBase)) {
            MongoDBKnowledgeBase oldMongoDBKnowledgeBase = (MongoDBKnowledgeBase)oldKnowledgeBase;
            return MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getHost(), this.host) && oldMongoDBKnowledgeBase.getPort() == this.port && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getDbName(), this.dbName) && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getUserName(), this.userName) && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getPassword(), this.password) && this.enableStatistics == oldMongoDBKnowledgeBase.enableStatistics && this.successfulLogging == oldMongoDBKnowledgeBase.successfulLogging;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof KnowledgeBase) {
            return this.equals((KnowledgeBase)other);
        }
        return false;
    }

    public static boolean equals(Object firstObject, Object secondObject) {
        if (firstObject == null) {
            return secondObject == null;
        }
        if (secondObject == null) {
            return false;
        }
        return secondObject.equals(firstObject);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    @Override
    public boolean isSuccessfulLogging() {
        return this.successfulLogging;
    }

    @Override
    public void saveStatistics(Statistics stat) {
        BasicDBObject object = new BasicDBObject();
        object.put("projectName", (Object)stat.getProjectName());
        object.put("buildNumber", (Object)stat.getBuildNumber());
        object.put("displayName", (Object)stat.getDisplayName());
        object.put("master", (Object)stat.getMaster());
        object.put("slaveHostName", (Object)stat.getSlaveHostName());
        object.put("startingTime", (Object)stat.getStartingTime());
        object.put("duration", (Object)stat.getDuration());
        object.put("timeZoneOffset", (Object)stat.getTimeZoneOffset());
        object.put("triggerCauses", stat.getTriggerCauses());
        BasicDBObject cause = null;
        if (stat.getUpstreamCause() != null) {
            cause = new BasicDBObject();
            Statistics.UpstreamCause upstreamCause = stat.getUpstreamCause();
            cause.put("project", (Object)upstreamCause.getUpstreamProject());
            cause.put("build", (Object)upstreamCause.getUpstreamBuild());
        }
        object.put("upstreamCause", (Object)cause);
        object.put("result", (Object)stat.getResult());
        List<FailureCauseStatistics> failureCauseStatisticsList = stat.getFailureCauseStatisticsList();
        this.addFailureCausesToDBObject((DBObject)object, failureCauseStatisticsList);
        this.getStatisticsCollection().insert(new DBObject[]{object});
    }

    @Override
    public List<Statistics> getStatistics(GraphFilterBuilder filter, int limit) {
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFields(filter);
        org.mongojack.DBCursor dbCursor = this.getJacksonStatisticsCollection().find(matchFields);
        BasicDBObject buildNumberDescending = new BasicDBObject("buildNumber", (Object)-1);
        dbCursor = dbCursor.sort((DBObject)buildNumberDescending);
        if (limit > 0) {
            dbCursor = dbCursor.limit(limit);
        }
        return dbCursor.toArray();
    }

    @Override
    public long getNbrOfNullFailureCauses(GraphFilterBuilder filter) {
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFields(filter);
        matchFields.put(COLLECTION_NAME, null);
        try {
            return this.getStatisticsCollection().count(matchFields);
        }
        catch (Exception e) {
            logger.fine("Unable to get number of null failure causes");
            e.printStackTrace();
            return -1L;
        }
    }

    @Override
    public Map<TimePeriod, Double> getUnknownFailureCauseQuotaPerTime(int intervalSize, GraphFilterBuilder filter) {
        HashMap<TimePeriod, Integer> unknownFailures = new HashMap<TimePeriod, Integer>();
        HashMap<TimePeriod, Integer> knownFailures = new HashMap<TimePeriod, Integer>();
        HashSet<TimePeriod> periods = new HashSet<TimePeriod>();
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFields(filter);
        BasicDBObject match = new BasicDBObject("$match", (Object)matchFields);
        BasicDBObject projectFields = new BasicDBObject();
        projectFields.put("startingTime", (Object)1);
        BasicDBObject nullToFalse = new BasicDBObject("$ifNull", Arrays.asList("$failureCauses", false));
        projectFields.put(COLLECTION_NAME, (Object)nullToFalse);
        BasicDBObject project = new BasicDBObject("$project", (Object)projectFields);
        DBObject idFields = this.generateTimeGrouping(intervalSize);
        BasicDBObject checkNullFailureCause = new BasicDBObject("$eq", Arrays.asList("$failureCauses", false));
        idFields.put("isNullFailureCause", (Object)checkNullFailureCause);
        BasicDBObject groupFields = new BasicDBObject();
        groupFields.put("_id", (Object)idFields);
        groupFields.put("number", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
        try {
            AggregationOutput output = this.getStatisticsCollection().aggregate((DBObject)match, new DBObject[]{project, group});
            for (DBObject result : output.results()) {
                DBObject groupedAttrs = (DBObject)result.get("_id");
                TimePeriod period = this.generateTimePeriodFromResult(result, intervalSize);
                periods.add(period);
                int number = (Integer)result.get("number");
                boolean isNullFailureCause = (Boolean)groupedAttrs.get("isNullFailureCause");
                if (isNullFailureCause) {
                    unknownFailures.put(period, number);
                    continue;
                }
                knownFailures.put(period, number);
            }
        }
        catch (Exception e) {
            logger.fine("Unable to get unknown failure cause quota per time");
            e.printStackTrace();
        }
        HashMap<TimePeriod, Double> nullFailureCauseQuotas = new HashMap<TimePeriod, Double>();
        for (TimePeriod timePeriod : periods) {
            int unknownFailureCount = 0;
            int knownFailureCount = 0;
            if (unknownFailures.containsKey(timePeriod)) {
                unknownFailureCount = (Integer)unknownFailures.get(timePeriod);
            }
            if (knownFailures.containsKey(timePeriod)) {
                knownFailureCount = (Integer)knownFailures.get(timePeriod);
            }
            double quota = unknownFailureCount == 0 ? 0.0 : (double)unknownFailureCount / (double)(unknownFailureCount + knownFailureCount);
            nullFailureCauseQuotas.put(timePeriod, quota);
        }
        return nullFailureCauseQuotas;
    }

    @Override
    public List<ObjectCountPair<String>> getNbrOfFailureCausesPerId(GraphFilterBuilder filter, int maxNbr) {
        ArrayList<ObjectCountPair<String>> nbrOfFailureCausesPerId = new ArrayList<ObjectCountPair<String>>();
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFields(filter);
        BasicDBObject match = new BasicDBObject("$match", (Object)matchFields);
        BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$failureCauses");
        BasicDBObject groupFields = new BasicDBObject();
        groupFields.put("_id", (Object)"$failureCauses.failureCause");
        groupFields.put("number", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
        BasicDBObject sort = new BasicDBObject("$sort", (Object)new BasicDBObject("number", (Object)-1));
        BasicDBObject limit = null;
        if (maxNbr > 0) {
            limit = new BasicDBObject("$limit", (Object)maxNbr);
        }
        try {
            AggregationOutput output = limit == null ? this.getStatisticsCollection().aggregate((DBObject)match, new DBObject[]{unwind, group, sort}) : this.getStatisticsCollection().aggregate((DBObject)match, new DBObject[]{unwind, group, sort, limit});
            for (DBObject result : output.results()) {
                DBRef failureCauseRef = (DBRef)result.get("_id");
                if (failureCauseRef == null) continue;
                Integer number = (Integer)result.get("number");
                String id = failureCauseRef.getId().toString();
                nbrOfFailureCausesPerId.add(new ObjectCountPair<String>(id, number));
            }
        }
        catch (Exception e) {
            logger.fine("Unable to get failure causes per id");
            e.printStackTrace();
        }
        return nbrOfFailureCausesPerId;
    }

    @Override
    public Date getLatestFailureForCause(String id) {
        try {
            BasicDBObject match = new BasicDBObject("failureCauses.failureCause.$id", (Object)new ObjectId(id));
            DBCursor output = this.getStatisticsCollection().find((DBObject)match).sort((DBObject)new BasicDBObject("startingTime", (Object)-1)).limit(1);
            for (DBObject result : output) {
                Date startingTime = (Date)result.get("startingTime");
                if (startingTime == null) continue;
                return startingTime;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting latest failure of cause", e);
        }
        return null;
    }

    @Override
    public Date getCreationDateForCause(String id) {
        Date creationDate;
        try {
            creationDate = new Date(new ObjectId(id).getTime());
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Could not retrieve original modification", e);
            creationDate = new Date(0L);
        }
        return creationDate;
    }

    @Override
    public void updateLastSeen(List<String> ids, Date seen) {
        LinkedList<ObjectId> objectIds = new LinkedList<ObjectId>();
        for (String id : ids) {
            objectIds.add(new ObjectId(id));
        }
        BasicDBObject match = new BasicDBObject("_id", (Object)new BasicDBObject("$in", objectIds));
        BasicDBObject set = new BasicDBObject("$set", (Object)new BasicDBObject("lastOccurred", (Object)seen));
        this.getJacksonCollection().updateMulti((DBObject)match, (DBObject)set);
    }

    private static DBObject generateMatchFieldsBase(GraphFilterBuilder filter) {
        BasicDBObject matchFields = new BasicDBObject();
        if (filter != null) {
            MongoDBKnowledgeBase.putNonNullStringValue((DBObject)matchFields, "master", filter.getMasterName());
            MongoDBKnowledgeBase.putNonNullStringValue((DBObject)matchFields, "slaveHostName", filter.getSlaveName());
            MongoDBKnowledgeBase.putNonNullStringValue((DBObject)matchFields, "projectName", filter.getProjectName());
            MongoDBKnowledgeBase.putNonNullStringValue((DBObject)matchFields, "result", filter.getResult());
            MongoDBKnowledgeBase.putNonNullBasicDBObject((DBObject)matchFields, "buildNumber", "$in", filter.getBuildNumbers());
            MongoDBKnowledgeBase.putNonNullBasicDBObject((DBObject)matchFields, "startingTime", "$gte", filter.getSince());
            MongoDBKnowledgeBase.putNonNullBasicDBObject((DBObject)matchFields, "result", "$ne", filter.getExcludeResult());
        }
        return matchFields;
    }

    private static DBObject generateMatchFields(GraphFilterBuilder filter) {
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFieldsBase(filter);
        MongoDBKnowledgeBase.putNonNullBasicDBObject(matchFields, "result", "$ne", "SUCCESS");
        return matchFields;
    }

    private static void putNonNullStringValue(DBObject dbObject, String key, String value) {
        if (value != null) {
            dbObject.put(key, (Object)value);
        }
    }

    private static void putNonNullBasicDBObject(DBObject dbObject, String key, String operator, Object value) {
        if (value != null) {
            dbObject.put(key, (Object)new BasicDBObject(operator, value));
        }
    }

    @Override
    public List<ObjectCountPair<FailureCause>> getNbrOfFailureCauses(GraphFilterBuilder filter) {
        List<ObjectCountPair<String>> nbrOfFailureCausesPerId = this.getNbrOfFailureCausesPerId(filter, 0);
        ArrayList<ObjectCountPair<FailureCause>> nbrOfFailureCauses = new ArrayList<ObjectCountPair<FailureCause>>();
        try {
            for (ObjectCountPair<String> countPair : nbrOfFailureCausesPerId) {
                String id = countPair.getObject();
                int count = countPair.getCount();
                FailureCause failureCause = this.getCause(id);
                if (failureCause == null) continue;
                nbrOfFailureCauses.add(new ObjectCountPair<FailureCause>(failureCause, count));
            }
        }
        catch (Exception e) {
            logger.fine("Unable to count failure causes");
            e.printStackTrace();
        }
        return nbrOfFailureCauses;
    }

    @Override
    public List<ObjectCountPair<String>> getFailureCauseNames(GraphFilterBuilder filter) {
        ArrayList<ObjectCountPair<String>> nbrOfFailureCauseNames = new ArrayList<ObjectCountPair<String>>();
        for (ObjectCountPair<FailureCause> countPair : this.getNbrOfFailureCauses(filter)) {
            FailureCause failureCause = countPair.getObject();
            if (failureCause.getName() == null) continue;
            nbrOfFailureCauseNames.add(new ObjectCountPair<String>(failureCause.getName(), countPair.getCount()));
        }
        return nbrOfFailureCauseNames;
    }

    @Override
    public Map<Integer, List<FailureCause>> getFailureCausesPerBuild(GraphFilterBuilder filter) {
        HashMap<Integer, List<FailureCause>> nbrOfFailureCausesPerBuild = new HashMap<Integer, List<FailureCause>>();
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFields(filter);
        BasicDBObject match = new BasicDBObject("$match", (Object)matchFields);
        BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$failureCauses");
        BasicDBObject groupFields = new BasicDBObject("_id", (Object)"$buildNumber");
        groupFields.put(COLLECTION_NAME, (Object)new BasicDBObject("$addToSet", (Object)"$failureCauses.failureCause"));
        BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
        BasicDBObject sort = new BasicDBObject("$sort", (Object)new BasicDBObject("_id", (Object)1));
        try {
            AggregationOutput output = this.getStatisticsCollection().aggregate((DBObject)match, new DBObject[]{unwind, group, sort});
            for (DBObject result : output.results()) {
                ArrayList<FailureCause> failureCauses = new ArrayList<FailureCause>();
                Integer buildNumber = (Integer)result.get("_id");
                BasicDBList failureCauseRefs = (BasicDBList)result.get(COLLECTION_NAME);
                for (Object o : failureCauseRefs) {
                    DBRef failureRef = (DBRef)o;
                    String id = failureRef.getId().toString();
                    FailureCause failureCause = this.getCause(id);
                    failureCauses.add(failureCause);
                }
                nbrOfFailureCausesPerBuild.put(buildNumber, failureCauses);
            }
        }
        catch (Exception e) {
            logger.fine("Unable to count failure causes by build");
            e.printStackTrace();
        }
        return nbrOfFailureCausesPerBuild;
    }

    private DBObject generateTimeGrouping(int intervalSize) {
        BasicDBObject timeFields = new BasicDBObject();
        if (intervalSize == 11) {
            timeFields.put("hour", (Object)new BasicDBObject("$hour", (Object)"$startingTime"));
        }
        if (intervalSize == 11 || intervalSize == 5) {
            timeFields.put("dayOfMonth", (Object)new BasicDBObject("$dayOfMonth", (Object)"$startingTime"));
        }
        timeFields.put("month", (Object)new BasicDBObject("$month", (Object)"$startingTime"));
        timeFields.put("year", (Object)new BasicDBObject("$year", (Object)"$startingTime"));
        return timeFields;
    }

    private TimePeriod generateTimePeriodFromResult(DBObject result, int intervalSize) {
        Month period;
        BasicDBObject groupedAttrs = (BasicDBObject)result.get("_id");
        int month = groupedAttrs.getInt("month");
        int year = groupedAttrs.getInt("year");
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.setTimeZone(new SimpleTimeZone(0, "UTC"));
        if (intervalSize == 11) {
            int dayOfMonth = groupedAttrs.getInt("dayOfMonth");
            c.set(5, dayOfMonth);
            int hour = groupedAttrs.getInt("hour");
            c.set(11, hour);
            period = new Hour(c.getTime());
        } else if (intervalSize == 5) {
            int dayOfMonth = groupedAttrs.getInt("dayOfMonth");
            c.set(5, dayOfMonth);
            period = new Day(c.getTime());
        } else {
            period = new Month(c.getTime());
        }
        return period;
    }

    @Override
    public List<FailureCauseTimeInterval> getFailureCausesPerTime(int intervalSize, GraphFilterBuilder filter, boolean byCategories) {
        ArrayList<FailureCauseTimeInterval> failureCauseIntervals = new ArrayList<FailureCauseTimeInterval>();
        HashMap<MultiKey, FailureCauseTimeInterval> categoryTable = new HashMap<MultiKey, FailureCauseTimeInterval>();
        DBObject matchFields = MongoDBKnowledgeBase.generateMatchFields(filter);
        BasicDBObject match = new BasicDBObject("$match", (Object)matchFields);
        BasicDBObject unwind = new BasicDBObject("$unwind", (Object)"$failureCauses");
        DBObject idFields = this.generateTimeGrouping(intervalSize);
        idFields.put("failureCause", (Object)"$failureCauses.failureCause");
        BasicDBObject groupFields = new BasicDBObject();
        groupFields.put("_id", (Object)idFields);
        groupFields.put("number", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
        AggregationOutput output = this.getStatisticsCollection().aggregate((DBObject)match, new DBObject[]{unwind, group});
        for (DBObject result : output.results()) {
            int number = (Integer)result.get("number");
            TimePeriod period = this.generateTimePeriodFromResult(result, intervalSize);
            BasicDBObject groupedAttrs = (BasicDBObject)result.get("_id");
            DBRef failureRef = (DBRef)groupedAttrs.get("failureCause");
            String id = failureRef.getId().toString();
            FailureCause failureCause = this.getCause(id);
            if (byCategories) {
                if (failureCause.getCategories() == null) continue;
                for (String category : failureCause.getCategories()) {
                    MultiKey multiKey = new MultiKey((Object)category, (Object)period);
                    FailureCauseTimeInterval interval = (FailureCauseTimeInterval)categoryTable.get(multiKey);
                    if (interval == null) {
                        interval = new FailureCauseTimeInterval(period, category, number);
                        categoryTable.put(multiKey, interval);
                        failureCauseIntervals.add(interval);
                        continue;
                    }
                    interval.addNumber(number);
                }
                continue;
            }
            FailureCauseTimeInterval timeInterval = new FailureCauseTimeInterval(period, failureCause.getName(), failureCause.getId(), number);
            failureCauseIntervals.add(timeInterval);
        }
        return failureCauseIntervals;
    }

    @Override
    public List<ObjectCountPair<String>> getNbrOfFailureCategoriesPerName(GraphFilterBuilder filter, int limit) {
        List<ObjectCountPair<String>> nbrOfFailureCausesPerId = this.getNbrOfFailureCausesPerId(filter, 0);
        HashMap<String, Integer> nbrOfFailureCategoriesPerName = new HashMap<String, Integer>();
        for (ObjectCountPair<String> countPair : nbrOfFailureCausesPerId) {
            String id = countPair.getObject();
            int count = countPair.getCount();
            FailureCause failureCause = null;
            try {
                failureCause = this.getCause(id);
            }
            catch (Exception e) {
                logger.fine("Unable to count failure causes by name");
                e.printStackTrace();
            }
            if (failureCause == null) continue;
            if (failureCause.getCategories() == null) {
                Integer currentNbr = (Integer)nbrOfFailureCategoriesPerName.get(null);
                if (currentNbr == null) {
                    currentNbr = 0;
                }
                currentNbr = currentNbr + count;
                nbrOfFailureCategoriesPerName.put(null, currentNbr);
                continue;
            }
            for (String category : failureCause.getCategories()) {
                Integer currentNbr = (Integer)nbrOfFailureCategoriesPerName.get(category);
                if (currentNbr == null) {
                    currentNbr = 0;
                }
                currentNbr = currentNbr + count;
                nbrOfFailureCategoriesPerName.put(category, currentNbr);
            }
        }
        List<ObjectCountPair<String>> countList = new ArrayList<ObjectCountPair<String>>();
        for (Map.Entry entry : nbrOfFailureCategoriesPerName.entrySet()) {
            String name = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            countList.add(new ObjectCountPair<String>(name, count));
        }
        Collections.sort(countList, ObjectCountPair.countComparator());
        if (limit > 0 && countList.size() > limit) {
            countList = countList.subList(0, limit);
        }
        return countList;
    }

    @Override
    public void removeBuildfailurecause(Run build) {
        BasicDBObject searchObj = new BasicDBObject();
        searchObj.put((Object)"projectName", (Object)build.getParent().getFullName());
        searchObj.put((Object)"buildNumber", (Object)build.getNumber());
        searchObj.put((Object)"master", (Object)BfaUtils.getMasterName());
        DBCursor dbcursor = this.getStatisticsCollection().find((DBObject)searchObj);
        if (dbcursor.size() > 0) {
            while (dbcursor.hasNext()) {
                this.getStatisticsCollection().remove(dbcursor.next());
                logger.log(Level.INFO, build.getDisplayName() + " build failure cause removed");
            }
        } else {
            logger.log(Level.INFO, build.getDisplayName() + " build failure cause value is null or initial scanning ");
        }
    }

    private void addFailureCausesToDBObject(DBObject object, List<FailureCauseStatistics> failureCauseStatisticsList) {
        if (failureCauseStatisticsList != null && !failureCauseStatisticsList.isEmpty()) {
            LinkedList<BasicDBObject> failureCauseStatisticsObjects = new LinkedList<BasicDBObject>();
            for (FailureCauseStatistics failureCauseStatistics : failureCauseStatisticsList) {
                BasicDBObject failureCauseStatisticsObject = new BasicDBObject();
                ObjectId id = new ObjectId(failureCauseStatistics.getId());
                DBRef failureCauseRef = new DBRef(this.dbName, COLLECTION_NAME, (Object)id);
                failureCauseStatisticsObject.put("failureCause", (Object)failureCauseRef);
                List<FoundIndication> foundIndicationList = failureCauseStatistics.getIndications();
                this.addIndicationsToDBObject((DBObject)failureCauseStatisticsObject, foundIndicationList);
                failureCauseStatisticsObjects.add(failureCauseStatisticsObject);
            }
            object.put(COLLECTION_NAME, failureCauseStatisticsObjects);
        }
    }

    private void addIndicationsToDBObject(DBObject object, List<FoundIndication> indications) {
        if (indications != null && !indications.isEmpty()) {
            LinkedList<BasicDBObject> foundIndicationObjects = new LinkedList<BasicDBObject>();
            for (FoundIndication foundIndication : indications) {
                BasicDBObject foundIndicationObject = new BasicDBObject();
                foundIndicationObject.put("pattern", (Object)foundIndication.getPattern());
                foundIndicationObject.put("matchingFile", (Object)foundIndication.getMatchingFile());
                foundIndicationObject.put("matchingString", (Object)foundIndication.getMatchingString());
                foundIndicationObjects.add(foundIndicationObject);
            }
            object.put("indications", foundIndicationObjects);
        }
    }

    public Descriptor<KnowledgeBase> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(MongoDBKnowledgeBaseDescriptor.class);
    }

    private MongoClient getMongoConnection() {
        if (this.mongo == null) {
            MongoClientOptions mongoClientOptions = MongoClientOptions.builder().connectTimeout(5000).serverSelectionTimeout(5000).build();
            if (this.password != null && Util.fixEmpty((String)this.password.getPlainText()) != null) {
                char[] pwd = this.password.getPlainText().toCharArray();
                MongoCredential credential = MongoCredential.createCredential((String)this.userName, (String)this.dbName, (char[])pwd);
                this.mongo = new MongoClient(new ServerAddress(this.host, this.port), credential, mongoClientOptions);
            } else {
                this.mongo = new MongoClient(new ServerAddress(this.host, this.port), mongoClientOptions);
            }
        }
        return this.mongo;
    }

    private DB getDb() {
        if (this.db == null) {
            this.db = this.getMongoConnection().getDB(this.dbName);
        }
        return this.db;
    }

    private DBCollection getCollection() {
        if (this.collection == null) {
            this.collection = this.getDb().getCollection(COLLECTION_NAME);
        }
        return this.collection;
    }

    private synchronized DBCollection getStatisticsCollection() {
        if (this.statisticsCollection == null) {
            this.statisticsCollection = this.getDb().getCollection(STATISTICS_COLLECTION_NAME);
        }
        return this.statisticsCollection;
    }

    private synchronized JacksonDBCollection<FailureCause, String> getJacksonCollection() {
        if (this.jacksonCollection == null) {
            if (this.collection == null) {
                this.collection = this.getCollection();
            }
            this.jacksonCollection = JacksonDBCollection.wrap((DBCollection)this.collection, FailureCause.class, String.class, (ObjectMapper)OBJECT_MAPPER);
        }
        return this.jacksonCollection;
    }

    private synchronized JacksonDBCollection<Statistics, String> getJacksonStatisticsCollection() {
        if (this.jacksonStatisticsCollection == null) {
            if (this.statisticsCollection == null) {
                this.statisticsCollection = this.getStatisticsCollection();
            }
            this.jacksonStatisticsCollection = JacksonDBCollection.wrap((DBCollection)this.statisticsCollection, Statistics.class, String.class, (ObjectMapper)OBJECT_MAPPER);
        }
        return this.jacksonStatisticsCollection;
    }

    @Extension
    public static class MongoDBKnowledgeBaseDescriptor
    extends KnowledgeBase.KnowledgeBaseDescriptor {
        public String getDisplayName() {
            return Messages.MongoDBKnowledgeBase_DisplayName();
        }

        public int getDefaultPort() {
            return 27017;
        }

        public FormValidation doCheckHost(@QueryParameter(value="value") String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)"Please provide a host name!");
            }
            Matcher m = Pattern.compile("\\s").matcher(value);
            if (m.find()) {
                return FormValidation.error((String)"Host name contains white space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter(value="value") String value) {
            try {
                Long.parseLong(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please provide a port number!");
            }
        }

        public FormValidation doCheckDbName(@QueryParameter(value="value") String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Please provide a database name!");
            }
            Matcher m = Pattern.compile("\\s").matcher(value);
            if (m.find()) {
                return FormValidation.error((String)"Database name contains white space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="host") String host, @QueryParameter(value="port") int port, @QueryParameter(value="dbName") String dbName, @QueryParameter(value="userName") String userName, @QueryParameter(value="password") String password) {
            MongoDBKnowledgeBase base = new MongoDBKnowledgeBase(host, port, dbName, userName, Secret.fromString((String)password), false, false);
            try {
                BasicDBObject ping = new BasicDBObject("ping", (Object)"1");
                DB db = base.getDb();
                db.command((DBObject)ping);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)Messages.MongoDBKnowledgeBase_ConnectionError());
            }
            return FormValidation.ok((String)Messages.MongoDBKnowledgeBase_ConnectionOK());
        }
    }
}

