/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.GerritMessageProvider;
import com.sonyericsson.jenkins.plugins.bfa.PluginImpl;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseBuildAction;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCauseDisplayData;
import com.sonyericsson.jenkins.plugins.bfa.model.FoundFailureCause;
import hudson.Extension;
import hudson.model.Run;
import java.util.List;
import jenkins.model.Jenkins;

@Extension(optional=true)
public class GerritMessageProviderExtension
extends GerritMessageProvider {
    public String getBuildCompletedMessage(Run build) {
        if (PluginImpl.getInstance().isGerritTriggerEnabled()) {
            FailureCauseBuildAction action;
            StringBuilder customMessage = new StringBuilder();
            if (build != null && (action = (FailureCauseBuildAction)build.getAction(FailureCauseBuildAction.class)) != null) {
                FailureCauseDisplayData displayData = action.getFailureCauseDisplayData();
                this.addFailureCausesFromData(customMessage, displayData);
                this.printDownstream(customMessage, displayData.getDownstreamFailureCauses());
                if (customMessage.length() > 0) {
                    return customMessage.toString().replace("'", "\"");
                }
            }
        }
        return null;
    }

    private void printDownstream(StringBuilder message, List<FailureCauseDisplayData> downstreamFailureCauses) {
        if (!downstreamFailureCauses.isEmpty()) {
            for (FailureCauseDisplayData displayData : downstreamFailureCauses) {
                this.addFailureCausesFromData(message, displayData);
                this.printDownstream(message, displayData.getDownstreamFailureCauses());
            }
        }
    }

    private void addFailureCausesFromData(StringBuilder message, FailureCauseDisplayData displayData) {
        for (FoundFailureCause failureCause : displayData.getFoundFailureCauses()) {
            if (message.length() > 0) {
                message.append("\n\n");
            }
            message.append(failureCause.getDescription());
            message.append(" ( ").append(Jenkins.getInstance().getRootUrl()).append(displayData.getLinks().getBuildUrl()).append(" )");
        }
    }
}

