/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.model.indication;

import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.model.BuildLogFailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureReader;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.Indication;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BuildLogIndication
extends Indication {
    private static final long serialVersionUID = -2889792693081908532L;
    private transient Pattern compiled = null;

    @DataBoundConstructor
    public BuildLogIndication(String pattern) {
        super(pattern);
    }

    public BuildLogIndication() {
    }

    @Override
    public FailureReader getReader() {
        return new BuildLogFailureReader(this);
    }

    @Override
    public Pattern getPattern() {
        if (this.compiled == null) {
            this.compiled = Pattern.compile(this.getUserProvidedExpression());
        }
        return this.compiled;
    }

    public Indication.IndicationDescriptor getDescriptor() {
        return (Indication.IndicationDescriptor)Hudson.getInstance().getDescriptorByType(BuildLogIndicationDescriptor.class);
    }

    @Extension
    public static class BuildLogIndicationDescriptor
    extends Indication.IndicationDescriptor {
        private static final Pattern URL_PATTERN = Pattern.compile("^(.*/)([^/]+)/([^/]+)/([^/]+)/?$");
        private static final int NUM_OF_URL_PARTS = 4;

        public String getDisplayName() {
            return Messages.BuildLogIndication_DisplayName();
        }

        public FormValidation doMatchText(@QueryParameter(value="pattern") String testPattern, @QueryParameter(value="testText") String testText, @QueryParameter(value="textSourceIsUrl") boolean textSourceIsUrl) {
            if (textSourceIsUrl) {
                Matcher urlMatcher = URL_PATTERN.matcher(testText = testText.replaceAll("/\\./", "/"));
                if (urlMatcher.matches()) {
                    MatrixConfiguration configuration;
                    AbstractProject project;
                    String[] urlParts = new String[4];
                    for (int i = 0; i < urlParts.length; ++i) {
                        urlParts[i] = urlMatcher.group(i + 1);
                    }
                    AbstractBuild build = null;
                    Jenkins getItemInstance = null;
                    if (urlParts[0].split("/job/").length > 1) {
                        String[] jobParts;
                        String fullFolderName = "";
                        String[] interestingJobParts = urlParts[0].split("/job/", 2);
                        for (String part : jobParts = interestingJobParts[interestingJobParts.length - 1].split("/job/")) {
                            fullFolderName = fullFolderName + "/" + part;
                        }
                        getItemInstance = (ItemGroup)Jenkins.getInstance().getItemByFullName(fullFolderName);
                    } else {
                        getItemInstance = Jenkins.getInstance();
                    }
                    if (getItemInstance.getItem(urlParts[2]) instanceof AbstractProject && this.isValidBuildId(urlParts[3])) {
                        project = (AbstractProject)getItemInstance.getItem(urlParts[2]);
                        build = this.getBuildById(project, urlParts[3]);
                    } else if (getItemInstance.getItem(urlParts[1]) instanceof MatrixProject && this.isValidBuildId(urlParts[3])) {
                        project = (MatrixProject)getItemInstance.getItem(urlParts[1]);
                        configuration = project.getItem(urlParts[2]);
                        build = this.getBuildById((AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>>)configuration, urlParts[3]);
                    } else if (getItemInstance.getItem(urlParts[1]) instanceof MatrixProject && this.isValidBuildId(urlParts[2])) {
                        MatrixProject matrixProject = (MatrixProject)getItemInstance.getItem(urlParts[1]);
                        configuration = matrixProject.getItem(urlParts[3]);
                        build = this.getBuildById((AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>>)configuration, urlParts[2]);
                    }
                    if (build != null) {
                        try {
                            FailureReader failureReader = this.getFailureReader(testPattern);
                            FoundIndication foundIndication = failureReader.scan(build);
                            if (foundIndication == null) {
                                return FormValidation.warning((String)Messages.StringDoesNotMatchPattern());
                            }
                            return FormValidation.okWithMarkup((String)foundIndication.getFirstMatchingLine());
                        }
                        catch (IOException e) {
                            return FormValidation.error((String)Messages.FailedToScanFile_Error());
                        }
                    }
                }
                return FormValidation.error((String)Messages.InvalidURL_Error());
            }
            try {
                if (testText.matches(testPattern)) {
                    return FormValidation.ok((String)Messages.StringMatchesPattern());
                }
                return FormValidation.warning((String)Messages.StringDoesNotMatchPattern());
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)Messages.InvalidPattern_Error());
            }
        }

        private boolean isValidBuildId(String id) {
            return id.matches("\\d+") || StringBuildId.fromString(id) != null;
        }

        private AbstractBuild getBuildById(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project, String id) {
            if (id.matches("\\d+")) {
                return project.getBuildByNumber(Integer.parseInt(id));
            }
            StringBuildId stringBuildId = StringBuildId.fromString(id);
            if (stringBuildId != null) {
                return stringBuildId.getBuild(project);
            }
            return null;
        }

        protected FailureReader getFailureReader(String testPattern) {
            return new BuildLogFailureReader(new BuildLogIndication(testPattern));
        }

        public static enum StringBuildId {
            LAST_BUILD("lastBuild"){

                @Override
                public AbstractBuild getBuild(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project) {
                    return project.getLastBuild();
                }
            }
            ,
            LAST_FAILED_BUILD("lastFailedBuild"){

                @Override
                public AbstractBuild getBuild(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project) {
                    return (AbstractBuild)project.getLastFailedBuild();
                }
            }
            ,
            LAST_UNSUCCESSFUL_BUILD("lastUnsuccessfulBuild"){

                @Override
                public AbstractBuild getBuild(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project) {
                    return (AbstractBuild)project.getLastUnsuccessfulBuild();
                }
            }
            ,
            LAST_SUCCESSFUL_BUILD("lastSuccessfulBuild"){

                @Override
                public AbstractBuild getBuild(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project) {
                    return (AbstractBuild)project.getLastSuccessfulBuild();
                }
            };

            private final String name;

            private StringBuildId(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public static StringBuildId fromString(String str) {
                if (str != null) {
                    for (StringBuildId stringBuildId : StringBuildId.values()) {
                        if (!str.equals(stringBuildId.getName())) continue;
                        return stringBuildId;
                    }
                }
                return null;
            }

            public abstract AbstractBuild getBuild(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> var1);
        }
    }
}

