/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.support;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.BuildMemoryReport;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.Diagnostics;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Extension(optional=true)
public class BuildMemoryComponent
extends Component {
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Diagnostics.getRequiredPermission());
    }

    @NonNull
    public String getDisplayName() {
        return "Gerrit: " + Messages.BuildMemoryReport_DisplayName();
    }

    public boolean isSelectedByDefault() {
        return false;
    }

    public void addContents(@NonNull Container container) {
        container.add((Content)new PrintedContent("gerrit/buildmemory.md"){

            protected void printTo(PrintWriter out) throws IOException {
                ToGerritRunListener toGerritRunListener = ToGerritRunListener.getInstance();
                if (toGerritRunListener == null) {
                    return;
                }
                BuildMemoryReport report = toGerritRunListener.report();
                out.println("#" + BuildMemoryComponent.this.getDisplayName());
                out.println();
                List<Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>> entries = report.getSortedEntrySet();
                for (Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>> entry : entries) {
                    out.print("###");
                    out.println(report.getDisplayNameFor(entry.getKey()));
                    for (BuildMemory.MemoryImprint.Entry en : entry.getValue()) {
                        Job job = en.getProject();
                        Run run = en.getBuild();
                        String name = "<unknown>";
                        if (job != null) {
                            name = job.getFullName();
                        }
                        String number = "";
                        if (run != null) {
                            number = run.getDisplayName();
                        }
                        String result = "";
                        if (run != null && run.getResult() != null) {
                            result = run.getResult().toString();
                        }
                        String startedAt = "";
                        if (en.getStartedTimestamp() != null) {
                            startedAt = BuildMemoryReport.TS_FORMAT.get().format(new Date(en.getStartedTimestamp()));
                        }
                        String completedAt = "";
                        if (en.getCompletedTimestamp() != null) {
                            completedAt = BuildMemoryReport.TS_FORMAT.get().format(new Date(en.getCompletedTimestamp()));
                        }
                        out.println(" * Job: " + name);
                        out.println("    - Run: " + number);
                        out.println("    - Completed: " + en.isBuildCompleted());
                        out.println("    - Cancelled: " + en.isCancelled());
                        out.println("    - Result: " + result);
                        out.println("    - Triggered@ " + BuildMemoryReport.TS_FORMAT.get().format(en.getTriggeredTimestamp()));
                        out.println("    - Started@ " + startedAt);
                        out.println("    - Completed@ " + completedAt);
                    }
                }
            }
        });
    }
}

