/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.JenkinsAwareGerritHandler;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.PluginConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContextConverter;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.workers.GerritWorkersConfig;
import com.thoughtworks.xstream.converters.Converter;
import hudson.Plugin;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportedBean
public class PluginImpl
extends Plugin {
    public static final String DISPLAY_NAME = "Gerrit Trigger";
    public static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(PluginImpl.class, Messages._GerritPermissionGroup());
    public static final Permission MANUAL_TRIGGER = new Permission(PERMISSION_GROUP, "ManualTrigger", Messages._ManualTriggerPermissionDescription(), Jenkins.ADMINISTER);
    public static final Permission RETRIGGER = new Permission(PERMISSION_GROUP, "Retrigger", Messages._RetriggerPermissionDescription(), Item.BUILD);
    private static final Logger logger = LoggerFactory.getLogger(PluginImpl.class);
    private final List<GerritServer> servers = new CopyOnWriteArrayList<GerritServer>();
    private transient GerritHandler gerritEventManager;
    private volatile transient boolean active = false;
    @Deprecated
    private transient IGerritHudsonTriggerConfig config;
    private PluginConfig pluginConfig;
    public static final String DEFAULT_SERVER_NAME = "defaultServer";
    public static final String TEST_SSH_KEYFILE_LOCATION_PROPERTY = PluginImpl.class.getName() + "_test_ssh_key_file";

    public Api getApi() {
        return new Api((Object)this);
    }

    @CheckForNull
    public static PluginImpl getInstance() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return (PluginImpl)jenkins.getPlugin(PluginImpl.class);
        }
        logger.debug("Error, Jenkins could not be found, so no plugin!");
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    @Exported
    public List<GerritServer> getServers() {
        return this.servers;
    }

    @Nonnull
    public static List<GerritServer> getServers_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("PluginImpl instance not found!");
            return Collections.emptyList();
        }
        return plugin.getServers();
    }

    public List<String> getServerNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (GerritServer s : this.getServers()) {
            names.add(s.getName());
        }
        return names;
    }

    @Nonnull
    public static List<String> getServerNames_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("PluginImpl instance not found!");
            return Collections.emptyList();
        }
        return plugin.getServerNames();
    }

    public GerritServer getServer(String name) {
        for (GerritServer s : this.servers) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @CheckForNull
    public static GerritServer getServer_(String name) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getServer(name);
    }

    @CheckForNull
    public GerritServer getFirstServer() {
        if (!this.servers.isEmpty()) {
            return this.servers.get(0);
        }
        return null;
    }

    @CheckForNull
    public static GerritServer getFirstServer_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getFirstServer();
    }

    public void setServers(List<GerritServer> servers) {
        if (this.servers != servers) {
            this.servers.clear();
            this.servers.addAll(servers);
        }
    }

    public List<GerritServer> addServer(GerritServer s) {
        this.servers.add(s);
        return this.servers;
    }

    public List<GerritServer> removeServer(GerritServer s) {
        this.servers.remove(s);
        return this.servers;
    }

    public boolean containsServer(String serverName) {
        boolean contains = false;
        for (GerritServer s : this.getServers()) {
            if (!s.getName().equals(serverName)) continue;
            contains = true;
        }
        return contains;
    }

    public static boolean containsServer_(String serverName) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return false;
        }
        return plugin.containsServer(serverName);
    }

    public static IGerritHudsonTriggerConfig getServerConfig(GerritTriggeredEvent event) {
        Provider provider = event.getProvider();
        if (provider != null) {
            GerritServer gerritServer = PluginImpl.getServer_(provider.getName());
            if (gerritServer != null) {
                return gerritServer.getConfig();
            }
            logger.warn("Could not find server config for {} - no such server.", (Object)provider.getName());
        } else {
            logger.warn("The event {} has no provider specified. BUG!", (Object)event);
        }
        return null;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    @CheckForNull
    public static PluginConfig getPluginConfig_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getPluginConfig();
    }

    public static void save_() throws IOException {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return;
        }
        plugin.save();
    }

    public GerritHandler getHandler() {
        return this.gerritEventManager;
    }

    @CheckForNull
    public static GerritHandler getHandler_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getHandler();
    }

    public List<Job> getConfiguredJobs(String serverName) {
        LinkedList<Job> configuredJobs = new LinkedList<Job>();
        for (Job project : Jenkins.getInstance().getItems(Job.class)) {
            GerritTrigger gerritTrigger = GerritTrigger.getTrigger(project);
            if (gerritTrigger == null || !gerritTrigger.getServerName().equals(serverName)) continue;
            configuredJobs.add(project);
        }
        return configuredJobs;
    }

    @Nonnull
    public static List<Job> getConfiguredJobs_(String serverName) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return Collections.emptyList();
        }
        return plugin.getConfiguredJobs(serverName);
    }

    public void start() throws Exception {
        logger.info("Starting Gerrit-Trigger Plugin");
        PluginImpl.doXStreamRegistrations();
        logger.trace("Loading configs");
        this.load();
        GerritSendCommandQueue.initialize((GerritWorkersConfig)this.pluginConfig);
        this.gerritEventManager = new JenkinsAwareGerritHandler(this.pluginConfig.getNumberOfReceivingWorkerThreads());
        for (GerritServer s : this.servers) {
            s.start();
        }
        this.active = true;
    }

    public void postInitialize() throws Exception {
        QueueTaskDispatcher.all().size();
        super.postInitialize();
    }

    public void load() throws IOException {
        super.load();
        if (this.pluginConfig == null) {
            PluginConfig conf = new PluginConfig();
            if (this.config != null) {
                conf.setNumberOfReceivingWorkerThreads(this.config.getNumberOfReceivingWorkerThreads());
                conf.setNumberOfSendingWorkerThreads(this.config.getNumberOfSendingWorkerThreads());
            }
            this.pluginConfig = conf;
        }
        if (this.servers.isEmpty()) {
            if (this.config != null) {
                GerritServer defaultServer = new GerritServer(DEFAULT_SERVER_NAME);
                defaultServer.setConfig(this.config);
                this.servers.add(defaultServer);
            }
            this.save();
        }
        if (System.getProperty(TEST_SSH_KEYFILE_LOCATION_PROPERTY) != null && !this.servers.isEmpty()) {
            File location = new File(System.getProperty(TEST_SSH_KEYFILE_LOCATION_PROPERTY));
            for (GerritServer server : this.servers) {
                ((Config)server.getConfig()).setGerritAuthKeyFile(location);
            }
        }
    }

    protected static void doXStreamRegistrations() {
        logger.trace("doing XStream alias registrations.");
        Items.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Jenkins.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Run.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Run.XSTREAM2.addCompatibilityAlias("com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ManualPatchsetCreated", ManualPatchsetCreated.class);
        Items.XSTREAM.aliasPackage("com.sonyericsson.hudson.plugins.gerrit.gerritevents", "com.sonymobile.tools.gerrit.gerritevents");
        Jenkins.XSTREAM.aliasPackage("com.sonyericsson.hudson.plugins.gerrit.gerritevents", "com.sonymobile.tools.gerrit.gerritevents");
        Run.XSTREAM.aliasPackage("com.sonyericsson.hudson.plugins.gerrit.gerritevents", "com.sonymobile.tools.gerrit.gerritevents");
        logger.trace("XStream alias registrations done.");
    }

    public void stop() throws Exception {
        this.active = false;
        for (GerritServer s : this.servers) {
            s.stop();
        }
        if (this.gerritEventManager != null) {
            this.gerritEventManager.shutdown(false);
            this.gerritEventManager = null;
        }
        GerritSendCommandQueue.shutdown();
        this.servers.clear();
    }
}

