/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import org.apache.tools.ant.types.selectors.SelectorUtils;

public interface CompareUtil {
    public boolean matches(String var1, String var2);

    public String getName();

    public static class RegExpCompareUtil
    implements CompareUtil {
        public boolean matches(String pattern, String str) {
            return str.matches(pattern);
        }

        public String getName() {
            return "RegExp";
        }
    }

    public static class PlainCompareUtil
    implements CompareUtil {
        public boolean matches(String pattern, String str) {
            return pattern.equalsIgnoreCase(str);
        }

        public String getName() {
            return "Plain";
        }
    }

    public static class AntCompareUtil
    implements CompareUtil {
        public boolean matches(String pattern, String str) {
            return SelectorUtils.matchPath((String)pattern, (String)str);
        }

        public String getName() {
            return "Path";
        }
    }
}

