/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMemory {
    private TreeMap<PatchSetKey, MemoryImprint> memory = new TreeMap();
    private static final Logger logger = LoggerFactory.getLogger(BuildMemory.class);

    public synchronized MemoryImprint getMemoryImprint(PatchSetKey key) {
        return this.memory.get(key);
    }

    public synchronized boolean isAllBuildsCompleted(PatchsetCreated event) {
        PatchSetKey key = this.createKey(event);
        return this.isAllBuildsCompleted(key);
    }

    public synchronized boolean isAllBuildsCompleted(PatchSetKey key) {
        MemoryImprint pb = this.memory.get(key);
        if (pb != null) {
            return pb.isAllBuildsCompleted();
        }
        return false;
    }

    public synchronized BuildsStartedStats getBuildsStartedStats(PatchSetKey key) {
        MemoryImprint pb = this.memory.get(key);
        if (pb != null) {
            return pb.getBuildsStartedStats();
        }
        return null;
    }

    public synchronized String getStatusReport(PatchSetKey key) {
        MemoryImprint pb = this.memory.get(key);
        if (pb != null) {
            return pb.getStatusReport();
        }
        return null;
    }

    public synchronized boolean isAllBuildsStarted(PatchsetCreated event) {
        PatchSetKey key = this.createKey(event);
        return this.isAllBuildsStarted(key);
    }

    public synchronized boolean isAllBuildsStarted(PatchSetKey key) {
        MemoryImprint pb = this.memory.get(key);
        if (pb != null) {
            return pb.isAllBuildsSet();
        }
        return false;
    }

    public synchronized PatchSetKey completed(PatchsetCreated event, AbstractBuild build) {
        PatchSetKey key = this.createKey(event);
        MemoryImprint pb = this.memory.get(key);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(key, pb);
        }
        pb.set(build.getProject(), build, true);
        return key;
    }

    public synchronized PatchSetKey started(PatchsetCreated event, AbstractBuild build) {
        PatchSetKey key = this.createKey(event);
        MemoryImprint pb = this.memory.get(key);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(key, pb);
        }
        pb.set(build.getProject(), build);
        return key;
    }

    public synchronized PatchSetKey triggered(PatchsetCreated event, AbstractProject project) {
        PatchSetKey key = this.createKey(event);
        MemoryImprint pb = this.memory.get(key);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(key, pb);
        }
        pb.set(project);
        return key;
    }

    public synchronized PatchSetKey retriggered(PatchsetCreated event, AbstractProject project, List<AbstractBuild> otherBuilds) {
        PatchSetKey key = this.createKey(event);
        MemoryImprint pb = this.memory.get(key);
        if (pb == null) {
            pb = new MemoryImprint(event);
            this.memory.put(key, pb);
            if (otherBuilds != null) {
                for (AbstractBuild build : otherBuilds) {
                    pb.set(build.getProject(), build, !build.isBuilding());
                }
            }
        }
        pb.reset(project);
        return key;
    }

    private PatchSetKey createKey(PatchsetCreated event) {
        return new PatchSetKey(event.getChange().getNumber(), event.getPatchSet().getNumber());
    }

    public synchronized void forget(PatchSetKey key) {
        this.memory.remove(key);
    }

    public synchronized void updateTriggerContext(PatchSetKey key, GerritCause cause, AbstractBuild r) {
        MemoryImprint imprint = this.getMemoryImprint(key);
        TriggerContext context = cause.getContext();
        context.setThisBuild(r);
        for (MemoryImprint.Entry entry : imprint.getEntries()) {
            if (entry.getBuild() != null && !entry.getBuild().equals(r)) {
                context.addOtherBuild(entry.getBuild());
                this.updateTriggerContext(entry, imprint);
                continue;
            }
            if (entry.getBuild() != null || entry.getProject().equals(r.getProject())) continue;
            context.addOtherProject(entry.getProject());
        }
        if (!r.hasntStartedYet() && !r.isBuilding()) {
            try {
                r.save();
            }
            catch (IOException ex) {
                logger.error("Could not save build state for build " + r, (Throwable)ex);
            }
        }
    }

    private synchronized void updateTriggerContext(MemoryImprint.Entry entryToUpdate, MemoryImprint imprint) {
        if (entryToUpdate.getBuild() != null) {
            GerritCause cause = null;
            List causes = entryToUpdate.getBuild().getCauses();
            for (Cause c : causes) {
                if (!(c instanceof GerritCause)) continue;
                cause = (GerritCause)c;
                break;
            }
            if (cause != null) {
                TriggerContext context = cause.getContext();
                for (MemoryImprint.Entry ent : imprint.getEntries()) {
                    if (ent.getBuild() != null && !ent.getBuild().equals(entryToUpdate.getBuild())) {
                        context.addOtherBuild(ent.getBuild());
                        continue;
                    }
                    if (ent.getBuild() != null || ent.getProject().equals(entryToUpdate.getProject())) continue;
                    context.addOtherProject(ent.getProject());
                }
                if (!entryToUpdate.getBuild().hasntStartedYet() && !entryToUpdate.getBuild().isBuilding()) {
                    try {
                        entryToUpdate.getBuild().save();
                    }
                    catch (IOException ex) {
                        logger.error("Could not save state for build " + entryToUpdate.getBuild(), (Throwable)ex);
                    }
                }
            }
        }
    }

    public synchronized boolean isBuilding(PatchsetCreated event, AbstractProject project) {
        PatchSetKey key = this.createKey(event);
        MemoryImprint pb = this.memory.get(key);
        if (pb == null) {
            return false;
        }
        for (MemoryImprint.Entry entry : pb.getEntries()) {
            if (!entry.getProject().equals(project)) continue;
            if (entry.getBuild() != null) {
                return !entry.isBuildCompleted();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isBuilding(PatchsetCreated event) {
        PatchSetKey key = this.createKey(event);
        MemoryImprint pb = this.memory.get(key);
        return pb != null;
    }

    public synchronized List<AbstractBuild> getBuilds(PatchSetKey key) {
        MemoryImprint pb = this.memory.get(key);
        if (pb != null) {
            LinkedList<AbstractBuild> list = new LinkedList<AbstractBuild>();
            for (MemoryImprint.Entry entry : pb.getEntries()) {
                if (entry.getBuild() == null) continue;
                list.add(entry.getBuild());
            }
            return list;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PatchSetKey
    implements Comparable<PatchSetKey> {
        private final Integer changeNumber;
        private final Integer patchSetNumber;

        public PatchSetKey(Integer changeNumber, Integer patchSetNumber) {
            this.changeNumber = changeNumber;
            this.patchSetNumber = patchSetNumber;
        }

        public PatchSetKey(String changeNumber, String patchSetNumber) throws NumberFormatException {
            this.changeNumber = new Integer(changeNumber);
            this.patchSetNumber = new Integer(patchSetNumber);
        }

        PatchSetKey(PatchsetCreated event) {
            this(event.getChange().getNumber(), event.getPatchSet().getNumber());
        }

        public Integer getChangeNumber() {
            return this.changeNumber;
        }

        public Integer getPatchSetNumber() {
            return this.patchSetNumber;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatchSetKey other = (PatchSetKey)obj;
            if (this.changeNumber != null && !this.changeNumber.equals(other.changeNumber) || this.changeNumber == null && other.changeNumber != null) {
                return false;
            }
            return (this.patchSetNumber == null || this.patchSetNumber.equals(other.patchSetNumber)) && (this.patchSetNumber != null || other.patchSetNumber == null);
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + (this.changeNumber != null ? this.changeNumber.hashCode() : 0);
            hash = 37 * hash + (this.patchSetNumber != null ? this.patchSetNumber.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(PatchSetKey o) {
            int changeComp = 0;
            if (this.changeNumber != null) {
                changeComp = this.changeNumber.compareTo(o.changeNumber);
            } else if (o.changeNumber != null) {
                return -1;
            }
            if (changeComp != 0) {
                return changeComp;
            }
            if (this.patchSetNumber != null) {
                return this.patchSetNumber.compareTo(o.patchSetNumber);
            }
            if (o.patchSetNumber != null) {
                return -1;
            }
            return 0;
        }
    }

    public static class MemoryImprint {
        private PatchsetCreated event;
        private List<Entry> list = new ArrayList<Entry>();

        public MemoryImprint(PatchsetCreated event) {
            this.event = event;
        }

        public MemoryImprint(PatchsetCreated event, AbstractProject project) {
            this.event = event;
            this.set(project);
        }

        public PatchsetCreated getEvent() {
            return this.event;
        }

        public synchronized Entry[] getEntries() {
            return this.list.toArray(new Entry[this.list.size()]);
        }

        protected synchronized void set(AbstractProject project, AbstractBuild build) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project, build);
                this.list.add(entry);
            } else {
                entry.setBuild(build);
            }
        }

        protected synchronized void set(AbstractProject project) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project);
                this.list.add(entry);
            }
        }

        protected synchronized void reset(AbstractProject project) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project);
                this.list.add(entry);
            } else {
                entry.setBuild(null);
                entry.setBuildCompleted(false);
            }
        }

        private synchronized void set(AbstractProject project, AbstractBuild build, boolean buildCompleted) {
            Entry entry = this.getEntry(project);
            if (entry == null) {
                entry = new Entry(project, build);
                entry.setBuildCompleted(buildCompleted);
                this.list.add(entry);
            } else {
                if (entry.getBuild() == null) {
                    entry.setBuild(build);
                }
                entry.setBuildCompleted(buildCompleted);
            }
        }

        public synchronized boolean isAllBuildsSet() {
            for (Entry entry : this.list) {
                if (entry.getBuild() != null) continue;
                return false;
            }
            return true;
        }

        public synchronized boolean isAllBuildsCompleted() {
            for (Entry entry : this.list) {
                if (entry.isBuildCompleted()) continue;
                return false;
            }
            return true;
        }

        public synchronized String getStatusReport() {
            StringBuilder str = new StringBuilder("");
            for (Entry entry : this.list) {
                if (entry.getProject() != null) {
                    str.append("  Project/Build: [").append(entry.getProject().getName()).append("]");
                    str.append(": [#");
                    if (entry.getBuild() != null) {
                        str.append(entry.getBuild().getNumber());
                        str.append(": ").append(entry.getBuild().getResult());
                    } else {
                        str.append("XX: NULL");
                    }
                    str.append("] Completed: ").append(entry.isBuildCompleted());
                } else {
                    str.append("  Project/Build: MISSING PROJECT!");
                }
                str.append("\n");
            }
            return str.toString();
        }

        private Entry getEntry(AbstractProject project) {
            for (Entry entry : this.list) {
                if (!entry.getProject().equals(project)) continue;
                return entry;
            }
            return null;
        }

        public synchronized BuildsStartedStats getBuildsStartedStats() {
            int started = 0;
            for (Entry entry : this.list) {
                if (entry.getBuild() == null) continue;
                ++started;
            }
            return new BuildsStartedStats(this.event, this.list.size(), started);
        }

        public synchronized boolean whereAllBuildsSuccessful() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null) {
                    return false;
                }
                if (!entry.isBuildCompleted()) {
                    return false;
                }
                if (entry.getBuild().getResult() == Result.SUCCESS) continue;
                return false;
            }
            return true;
        }

        public synchronized boolean whereAnyBuildsFailed() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null || !entry.isBuildCompleted() || entry.getBuild().getResult() != Result.FAILURE) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean whereAnyBuildsUnstable() {
            for (Entry entry : this.list) {
                if (entry.getBuild() == null || !entry.isBuildCompleted() || entry.getBuild().getResult() != Result.UNSTABLE) continue;
                return true;
            }
            return false;
        }

        public static class Entry {
            private AbstractProject project;
            private AbstractBuild build;
            private boolean buildCompleted;

            private Entry(AbstractProject project, AbstractBuild build) {
                this.project = project;
                this.build = build;
                this.buildCompleted = false;
            }

            private Entry(AbstractProject project) {
                this.project = project;
                this.buildCompleted = false;
            }

            public AbstractProject getProject() {
                return this.project;
            }

            public AbstractBuild getBuild() {
                return this.build;
            }

            private void setBuild(AbstractBuild build) {
                this.build = build;
            }

            public boolean isBuildCompleted() {
                return this.buildCompleted;
            }

            private void setBuildCompleted(boolean buildCompleted) {
                this.buildCompleted = buildCompleted;
            }
        }
    }
}

