/*
 * Decompiled with CFR 0.152.
 */
package com.somospnt.test.server;

import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.test.web.client.response.MockRestResponseCreators;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractMockRestOperation {
    protected MockRestServiceServer mockServer;
    protected HttpStatus status;

    protected abstract String getUrl();

    protected abstract HttpMethod getHttpMethod();

    protected abstract ResponseCreator getSuccessResponse();

    protected ResponseCreator getErrorResponse() {
        return MockRestResponseCreators.withStatus((HttpStatus)this.status);
    }

    protected RequestMatcher getExpect() {
        return MockRestRequestMatchers.requestTo((String)this.getUrl());
    }

    public MockRestServiceServer mock(RestTemplate restTemplate) {
        this.mockServer = MockRestServiceServer.createServer((RestTemplate)restTemplate);
        this.mock(this.mockServer);
        return this.mockServer;
    }

    public void mock(MockRestServiceServer mockServer) {
        if (this.isSuccess(this.status)) {
            mockServer.expect(MockRestRequestMatchers.method((HttpMethod)this.getHttpMethod())).andExpect(this.getExpect()).andRespond(this.getSuccessResponse());
        } else {
            mockServer.expect(MockRestRequestMatchers.method((HttpMethod)this.getHttpMethod())).andExpect(this.getExpect()).andRespond(this.getErrorResponse());
        }
    }

    protected boolean isSuccess(HttpStatus status) {
        return status != null && status.is2xxSuccessful();
    }
}

