/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.common.util.UTF8Util;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.XMLContentMessage;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.TextMessageIF;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;

public class SolTextMessage
extends SolMessage
implements TextMessageIF {
    private static final long serialVersionUID = -752119765897306398L;
    private String mText = null;

    public SolTextMessage() {
    }

    public SolTextMessage(BytesXMLMessage message) {
        super(message);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.mText = null;
    }

    public void setText(String string) throws JMSException {
        if (this.mBodyMode != SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotWriteableException("The message is read only");
        }
        this.mText = string;
    }

    public String getText() throws JMSException {
        this.load();
        return this.mText;
    }

    private void load() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            if (this.mMessage instanceof TextMessage) {
                this.mText = ((TextMessage)this.mMessage).getText();
            } else if (this.mMessage instanceof XMLContentMessage) {
                this.mText = ((XMLContentMessage)this.mMessage).getXMLContent();
            } else {
                byte[] data = this.mMessage.getBytes();
                if (data != null) {
                    this.mText = UTF8Util.getStringFromUTF8(data, 0, this.mMessage.getContentLength());
                }
            }
            this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.load();
        out.defaultWriteObject();
    }
}

