/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class GrowableByteBuffer {
    private ByteBuffer buf = null;
    private int maxsize = Integer.MAX_VALUE;

    GrowableByteBuffer(int size) {
        this.buf = ByteBuffer.allocate(size);
    }

    public static GrowableByteBuffer allocate(int capacity) {
        return new GrowableByteBuffer(capacity);
    }

    public static GrowableByteBuffer allocate(int capacity, int sizelimit) {
        GrowableByteBuffer b = new GrowableByteBuffer(capacity);
        b.setSizeLimit(sizelimit);
        return b;
    }

    private void setSizeLimit(int sizelimit) {
        this.maxsize = sizelimit;
    }

    public int limit() {
        return this.buf.limit();
    }

    public Buffer flip() {
        return this.buf.flip();
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        return this.buf.get(dst, offset, length);
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public int position() {
        return this.buf.position();
    }

    public Buffer clear() {
        return this.buf.clear();
    }

    public ByteBuffer put(byte b) {
        return this.buf.put(new byte[]{b});
    }

    public ByteBuffer put(byte[] buffer, int i, int param_sz) {
        return this.buf.put(buffer, i, param_sz);
    }

    public ByteBuffer get(byte[] dst) {
        return this.buf.get(dst);
    }

    public byte get() {
        return this.buf.get();
    }

    public ByteBuffer put(byte[] src) {
        int origPosition = this.buf.position();
        int param_sz = src.length;
        while (true) {
            try {
                return this.buf.put(src);
            }
            catch (BufferOverflowException e) {
                this.growBuf(param_sz, origPosition);
                continue;
            }
            break;
        }
    }

    public void ensureObjectFit(int objectSize) throws BufferOverflowException {
        if (this.buf.capacity() < this.buf.position() + objectSize) {
            this.growBuf(objectSize, this.buf.position());
        }
    }

    private void growBuf(int objectSizeHint, int origPosition) throws BufferOverflowException {
        long newSize;
        if (this.buf.capacity() == this.maxsize || origPosition + objectSizeHint > this.maxsize) {
            throw new BufferOverflowException();
        }
        for (newSize = (long)(2 * this.buf.capacity()); newSize < (long)(origPosition + objectSizeHint); newSize = 2L * newSize) {
        }
        newSize = Math.min(newSize, (long)this.maxsize);
        ByteBuffer newBuf = ByteBuffer.allocate((int)newSize);
        newBuf.put(this.buf.array(), 0, origPosition);
        this.buf = newBuf;
    }
}

